/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.dflib.DataFrame;
import org.dflib.avro.AvroLoader;
import org.dflib.avro.AvroSaver;
import org.dflib.avro.AvroSchemaLoader;
import org.dflib.avro.AvroSchemaSaver;
import org.dflib.avro.schema.AvroSchemaCompiler;
import org.dflib.avro.types.SingleSchemaConversion;
import org.dflib.avro.types.SingletonLogicalTypeFactory;

public class Avro {
    public static void registerCustomType(SingleSchemaConversion<?> conversion) {
        Avro.registerCustomLogicalType(conversion.getLogicalType());
        GenericData.get().addLogicalTypeConversion(conversion);
    }

    protected static void registerCustomLogicalType(LogicalType logicalType) {
        SingletonLogicalTypeFactory typeFactory = new SingletonLogicalTypeFactory(logicalType);
        LogicalTypes.register((String)logicalType.getName(), (LogicalTypes.LogicalTypeFactory)typeFactory);
    }

    public static Schema compileSchema(DataFrame data, String namespace, String name) {
        return Avro.schemaCompiler().namespace(namespace).name(name).compileSchema(data);
    }

    public static AvroSchemaCompiler schemaCompiler() {
        return new AvroSchemaCompiler();
    }

    public static DataFrame load(File file) {
        return Avro.loader().load(file);
    }

    public static DataFrame load(Path filePath) {
        return Avro.loader().load(filePath);
    }

    public static DataFrame load(String filePath) {
        return Avro.loader().load(filePath);
    }

    public static DataFrame load(byte[] bytes) {
        return Avro.loader().load(bytes);
    }

    public static AvroLoader loader() {
        return new AvroLoader();
    }

    public static Schema loadSchema(Path path) {
        return Avro.schemaLoader().load(path);
    }

    public static Schema loadSchema(File file) {
        return Avro.schemaLoader().load(file);
    }

    public static Schema loadSchema(String filePath) {
        return Avro.schemaLoader().load(filePath);
    }

    public static Schema loadSchema(InputStream in) {
        return Avro.schemaLoader().load(in);
    }

    public static AvroSchemaLoader schemaLoader() {
        return new AvroSchemaLoader();
    }

    public static void save(DataFrame df, Path filePath) {
        Avro.saver().save(df, filePath);
    }

    public static void save(DataFrame df, String filePath) {
        Avro.saver().save(df, filePath);
    }

    public static void save(DataFrame df, File file) {
        Avro.saver().save(df, file);
    }

    public static void save(DataFrame df, OutputStream out) {
        Avro.saver().save(df, out);
    }

    public static AvroSaver saver() {
        return new AvroSaver();
    }

    public static void saveSchema(DataFrame df, Path filePath) {
        Avro.schemaSaver().save(df, filePath);
    }

    public static void saveSchema(DataFrame df, String filePath) {
        Avro.schemaSaver().save(df, filePath);
    }

    public static void saveSchema(DataFrame df, File file) {
        Avro.schemaSaver().save(df, file);
    }

    public static void saveSchema(DataFrame df, OutputStream out) {
        Avro.schemaSaver().save(df, out);
    }

    public static void saveSchema(Schema schema, String filePath) {
        Avro.schemaSaver().save(schema, filePath);
    }

    public static void saveSchema(Schema schema, Path filePath) {
        Avro.schemaSaver().save(schema, filePath);
    }

    public static void saveSchema(Schema schema, File file) {
        Avro.schemaSaver().save(schema, file);
    }

    public static void saveSchema(Schema schema, OutputStream out) {
        Avro.schemaSaver().save(schema, out);
    }

    public static AvroSchemaSaver schemaSaver() {
        return new AvroSchemaSaver();
    }
}

