/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableFileInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Extractor;
import org.dflib.Index;
import org.dflib.avro.schema.AvroSchemaUtils;
import org.dflib.avro.types.AvroTypeExtensions;
import org.dflib.builder.DataFrameAppender;

public class AvroLoader {
    private Schema schema;

    public AvroLoader schema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public DataFrame load(File file) {
        DataFrame dataFrame;
        SeekableFileInput in = new SeekableFileInput(file);
        try {
            dataFrame = this.load((SeekableInput)in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading Avro file: " + file, e);
            }
        }
        in.close();
        return dataFrame;
    }

    public DataFrame load(Path filePath) {
        return this.load(filePath.toFile());
    }

    public DataFrame load(String filePath) {
        return this.load(new File(filePath));
    }

    public DataFrame load(byte[] bytes) {
        DataFrame dataFrame;
        SeekableByteArrayInput in = new SeekableByteArrayInput(bytes);
        try {
            dataFrame = this.load((SeekableInput)in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading Avro bytes", e);
            }
        }
        in.close();
        return dataFrame;
    }

    protected DataFrame load(SeekableInput in) throws IOException {
        GenericDatumReader reader = new GenericDatumReader(this.schema);
        DataFileReader inReader = new DataFileReader(in, (DatumReader)reader);
        Schema schema = reader.getExpected();
        Index index = this.createIndex(schema);
        DataFrameAppender appender = DataFrame.byRow(this.mapColumns(schema)).columnIndex(index).appender();
        GenericRecord record = null;
        while (inReader.hasNext()) {
            record = (GenericRecord)inReader.next(record);
            appender.append((Object)record);
        }
        DataFrame df = appender.toDataFrame();
        return this.fromAvroTypes(df, schema);
    }

    protected Index createIndex(Schema schema) {
        String[] labels = (String[])schema.getFields().stream().map(Schema.Field::name).toArray(String[]::new);
        return Index.of((String[])labels);
    }

    protected Extractor<GenericRecord, ?>[] mapColumns(Schema schema) {
        List fields = schema.getFields();
        int w = fields.size();
        Extractor[] extractors = new Extractor[w];
        for (int i = 0; i < w; ++i) {
            extractors[i] = this.mapColumn(i, ((Schema.Field)fields.get(i)).schema());
        }
        return extractors;
    }

    protected Extractor<GenericRecord, ?> mapColumn(int pos, Schema columnSchema) {
        switch (columnSchema.getType()) {
            case INT: {
                return Extractor.$int(r -> (Integer)r.get(pos));
            }
            case DOUBLE: {
                return Extractor.$double(r -> (Double)r.get(pos));
            }
            case LONG: {
                return Extractor.$long(r -> (Long)r.get(pos));
            }
            case BOOLEAN: {
                return Extractor.$bool(r -> (Boolean)r.get(pos));
            }
            case STRING: 
            case BYTES: 
            case ENUM: 
            case NULL: {
                return Extractor.$col(r -> r.get(pos));
            }
            case UNION: {
                return this.mapUnionColumn(pos, columnSchema.getTypes());
            }
        }
        throw new UnsupportedOperationException("(Yet) unsupported Avro schema type: " + columnSchema.getType());
    }

    protected Extractor<GenericRecord, ?> mapUnionColumn(int pos, List<Schema> types) {
        boolean hasNull;
        Schema[] otherThanNull = (Schema[])types.stream().filter(t -> t.getType() != Schema.Type.NULL).toArray(Schema[]::new);
        if (otherThanNull.length != 1) {
            throw new IllegalStateException("Can't handle union type that is not ['something', null]: " + types);
        }
        boolean bl = hasNull = types.size() > 1;
        if (!hasNull) {
            return this.mapColumn(pos, otherThanNull[0]);
        }
        switch (otherThanNull[0].getType()) {
            case INT: 
            case DOUBLE: 
            case LONG: 
            case BOOLEAN: 
            case STRING: 
            case BYTES: 
            case ENUM: {
                return Extractor.$col(r -> r.get(pos));
            }
            case UNION: {
                return this.mapUnionColumn(pos, otherThanNull[0].getTypes());
            }
        }
        throw new UnsupportedOperationException("(Yet) unsupported Avro schema type: " + otherThanNull[0].getType());
    }

    protected DataFrame fromAvroTypes(DataFrame df, Schema schema) {
        for (Schema.Field f : schema.getFields()) {
            Schema fSchema = f.schema().isUnion() ? AvroSchemaUtils.unpackUnion(f.schema()) : f.schema();
            if (!AvroSchemaUtils.isEnum(fSchema)) continue;
            Class enumType = AvroSchemaUtils.knownEnumType(fSchema);
            if (enumType != null) {
                df = df.cols(new String[]{f.name()}).merge(new Exp[]{Exp.$col((String)f.name()).castAsStr().castAsEnum(enumType)});
                continue;
            }
            df = df.cols(new String[]{f.name()}).merge(new Exp[]{Exp.$col((String)f.name()).castAsStr()});
        }
        return df;
    }

    static {
        AvroTypeExtensions.initIfNeeded();
    }
}

