/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.SyncableFileOutputStream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.avro.BaseSaver;
import org.dflib.avro.RowToAvroRecordAdapter;
import org.dflib.avro.schema.AvroSchemaUtils;
import org.dflib.row.RowProxy;

public class AvroSaver
extends BaseSaver<AvroSaver> {
    private CodecFactory codec;
    private Schema schema;

    public AvroSaver codec(CodecFactory codec) {
        this.codec = codec;
        return this;
    }

    public AvroSaver schema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public void save(DataFrame df, OutputStream out) {
        Schema schema = this.getOrCreateSchema(df);
        try {
            this.doSave(df, schema, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing records as Avro: " + e.getMessage(), e);
        }
    }

    public void save(DataFrame df, File file) {
        this.createMissingDirsIfNeeded(file);
        try (SyncableFileOutputStream out = new SyncableFileOutputStream(file);){
            this.save(df, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing Avro file '" + file + "': " + e.getMessage(), e);
        }
    }

    public void save(DataFrame df, Path filePath) {
        this.save(df, filePath.toFile());
    }

    public void save(DataFrame df, String fileName) {
        this.save(df, new File(fileName));
    }

    protected Schema getOrCreateSchema(DataFrame df) {
        return this.schema != null ? this.schema : this.schemaBuilder.compileSchema(df);
    }

    protected void doSave(DataFrame df, Schema schema, OutputStream out) throws IOException {
        DataFrame avroReadyDf = this.makeAvroReady(df, schema);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        try (DataFileWriter outWriter = new DataFileWriter((DatumWriter)writer);){
            if (this.codec != null) {
                outWriter.setCodec(this.codec);
            }
            outWriter.create(schema, out);
            RowToAvroRecordAdapter record = new RowToAvroRecordAdapter(schema);
            for (RowProxy r : avroReadyDf) {
                outWriter.append((Object)record.resetRow(r));
            }
        }
    }

    protected DataFrame makeAvroReady(DataFrame df, Schema schema) {
        for (Schema.Field f : schema.getFields()) {
            Schema fSchema;
            Schema schema2 = fSchema = f.schema().isUnion() ? AvroSchemaUtils.unpackUnion(f.schema()) : f.schema();
            if (AvroSchemaUtils.isEnum(fSchema)) {
                df = df.cols(new String[]{f.name()}).merge(new Exp[]{Exp.$col((String)f.name()).mapVal(v -> new GenericData.EnumSymbol(fSchema, v))});
                continue;
            }
            if (!AvroSchemaUtils.isUnmapped(fSchema)) continue;
            df = df.cols(new String[]{f.name()}).merge(new Exp[]{Exp.$col((String)f.name()).castAsStr()});
        }
        return df;
    }
}

