/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.apache.avro.Schema;
import org.apache.avro.file.SeekableFileInput;
import org.dflib.avro.types.AvroTypeExtensions;

public class AvroSchemaLoader {
    public Schema load(Path filePath) {
        return this.load(filePath.toFile());
    }

    public Schema load(String filePath) {
        return this.load(new File(filePath));
    }

    public Schema load(File file) {
        Schema schema;
        SeekableFileInput in = new SeekableFileInput(file);
        try {
            schema = this.load((InputStream)in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading Avro schema file: " + file, e);
            }
        }
        in.close();
        return schema;
    }

    public Schema load(InputStream in) {
        try {
            return new Schema.Parser().parse(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading Avro bytes", e);
        }
    }

    static {
        AvroTypeExtensions.initIfNeeded();
    }
}

