/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.apache.avro.Schema;
import org.dflib.DataFrame;
import org.dflib.avro.BaseSaver;

public class AvroSchemaSaver
extends BaseSaver<AvroSchemaSaver> {
    public void save(DataFrame df, Path filePath) {
        Schema schema = this.schemaBuilder.compileSchema(df);
        this.save(schema, filePath.toFile());
    }

    public void save(DataFrame df, String fileName) {
        Schema schema = this.schemaBuilder.compileSchema(df);
        this.save(schema, fileName);
    }

    public void save(DataFrame df, File file) {
        Schema schema = this.schemaBuilder.compileSchema(df);
        this.save(schema, file);
    }

    public void save(DataFrame df, OutputStream out) {
        Schema schema = this.schemaBuilder.compileSchema(df);
        this.save(schema, out);
    }

    public void save(Schema schema, Path filePath) {
        this.save(schema, filePath.toFile());
    }

    public void save(Schema schema, String fileName) {
        this.save(schema, new File(fileName));
    }

    public void save(Schema schema, File file) {
        this.createMissingDirsIfNeeded(file);
        try (FileOutputStream out = new FileOutputStream(file);){
            this.save(schema, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing Avro file '" + file + "': " + e.getMessage(), e);
        }
    }

    public void save(Schema schema, OutputStream out) {
        try {
            this.doSave(schema, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing records as Avro: " + e.getMessage(), e);
        }
    }

    protected void doSave(Schema schema, OutputStream out) throws IOException {
        byte[] bytes = schema.toString().getBytes(StandardCharsets.UTF_8);
        out.write(bytes);
    }
}

