/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro;

import java.io.File;
import org.dflib.avro.schema.AvroSchemaCompiler;
import org.dflib.avro.types.AvroTypeExtensions;

public abstract class BaseSaver<SELF extends BaseSaver<SELF>> {
    private boolean createMissingDirs;
    protected final AvroSchemaCompiler schemaBuilder = new AvroSchemaCompiler();

    protected BaseSaver() {
    }

    public SELF createMissingDirs() {
        this.createMissingDirs = true;
        return (SELF)this;
    }

    public SELF name(String name) {
        this.schemaBuilder.name(name);
        return (SELF)this;
    }

    public SELF namespace(String namespace) {
        this.schemaBuilder.namespace(namespace);
        return (SELF)this;
    }

    protected void createMissingDirsIfNeeded(File file) {
        File dir;
        if (this.createMissingDirs && (dir = file.getParentFile()) != null) {
            dir.mkdirs();
        }
    }

    static {
        AvroTypeExtensions.initIfNeeded();
    }
}

