/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro.schema;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Conversion;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.dflib.DataFrame;
import org.dflib.Series;
import org.dflib.avro.types.AvroTypeExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaCompiler {
    public static final String PROPERTY_DFLIB_ENUM_TYPE = "dflib.enum.type";
    private static final Logger LOGGER;
    private static final String DEFAULT_NAME = "DataFrame";
    private static final String DEFAULT_NAMESPACE = "org.dflib";
    protected String name;
    protected String namespace;

    public AvroSchemaCompiler name(String name) {
        this.name = name;
        return this;
    }

    public AvroSchemaCompiler namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public Schema compileSchema(DataFrame df) {
        String name = this.name != null ? this.name : DEFAULT_NAME;
        String namespace = this.namespace != null ? this.namespace : DEFAULT_NAMESPACE;
        SchemaBuilder.FieldAssembler fields = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)name).namespace(namespace)).fields();
        for (String column : df.getColumnsIndex()) {
            this.createSchemaField((SchemaBuilder.FieldAssembler<Schema>)fields, column, df.getColumn(column));
        }
        return (Schema)fields.endRecord();
    }

    protected void createSchemaField(SchemaBuilder.FieldAssembler<Schema> builder, String columnName, Series<?> column) {
        this.validateColumnName(columnName);
        builder.name(columnName).type(this.createColumnSchema(column)).noDefault();
    }

    protected Schema createColumnSchema(Series<?> column) {
        String name;
        Class type = column.getInferredType();
        if (type.isEnum()) {
            return this.makeNullable(this.enumSchema(type));
        }
        switch (name = type.isArray() ? type.getComponentType().getName() + "[]" : type.getName()) {
            case "int": {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case "java.lang.Integer": {
                return this.makeNullable(Schema.create((Schema.Type)Schema.Type.INT));
            }
            case "long": {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case "java.lang.Long": {
                return this.makeNullable(Schema.create((Schema.Type)Schema.Type.LONG));
            }
            case "float": {
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case "java.lang.Float": {
                return this.makeNullable(Schema.create((Schema.Type)Schema.Type.FLOAT));
            }
            case "double": {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case "java.lang.Double": {
                return this.makeNullable(Schema.create((Schema.Type)Schema.Type.DOUBLE));
            }
            case "boolean": {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case "java.lang.Boolean": {
                return this.makeNullable(Schema.create((Schema.Type)Schema.Type.BOOLEAN));
            }
            case "java.lang.String": {
                return this.makeNullable(this.stringSchema());
            }
        }
        Schema logicalTypeSchema = this.logicalTypeSchema(type);
        if (logicalTypeSchema != null) {
            return this.makeNullable(logicalTypeSchema);
        }
        Schema nullsOnlySchema = this.nullsOnlySchema(column);
        if (nullsOnlySchema != null) {
            return nullsOnlySchema;
        }
        return this.makeNullable(this.unmappedValueSchema(type));
    }

    protected Schema enumSchema(Class<?> enumType) {
        String name = enumType.getSimpleName();
        String namespace = enumType.getPackage() != null ? enumType.getPackage().getName() : null;
        String typeName = enumType.getName();
        List values = Arrays.stream(enumType.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
        Schema schema = Schema.createEnum((String)name, (String)namespace, null, values);
        schema.addProp(PROPERTY_DFLIB_ENUM_TYPE, typeName);
        return schema;
    }

    protected Schema stringSchema() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        GenericData.setStringType((Schema)schema, (GenericData.StringType)GenericData.StringType.String);
        return schema;
    }

    protected Schema logicalTypeSchema(Class<?> type) {
        Conversion c = GenericData.get().getConversionByClass(type);
        return c != null ? c.getRecommendedSchema() : null;
    }

    protected Schema nullsOnlySchema(Series<?> column) {
        if (column.size() == 0) {
            return null;
        }
        for (Object o : column) {
            if (o == null) continue;
            return null;
        }
        return Schema.create((Schema.Type)Schema.Type.NULL);
    }

    protected Schema unmappedValueSchema(Class<?> type) {
        LOGGER.warn("Unmapped schema type '{}'. Will use 'toString()' conversion and will deserialize as String", (Object)type.getName());
        return AvroTypeExtensions.UNMAPPED_TYPE.getRecommendedSchema();
    }

    protected Schema makeNullable(Schema schema) {
        return schema.getType() == Schema.Type.NULL ? schema : Schema.createUnion((Schema[])new Schema[]{schema, Schema.create((Schema.Type)Schema.Type.NULL)});
    }

    protected void validateColumnName(String name) {
        int length = name.length();
        if (length == 0) {
            throw new RuntimeException("Empty column name");
        }
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            throw new RuntimeException("Column name can not be used as an Avro field name. Name: '" + name + "', invalid first char: " + first);
        }
        for (int i = 1; i < length; ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            throw new RuntimeException("Column name can not be used as an Avro field name. Name: '" + name + "', invalid char: " + c);
        }
    }

    static {
        AvroTypeExtensions.initIfNeeded();
        LOGGER = LoggerFactory.getLogger(AvroSchemaCompiler.class);
    }
}

