/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro.schema;

import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.dflib.avro.types.AvroTypeExtensions;

public class AvroSchemaUtils {
    public static Schema unpackUnion(Schema union) {
        for (Schema child : union.getTypes()) {
            if (child.isNullable()) continue;
            return child;
        }
        return null;
    }

    public static boolean isEnum(Schema schema) {
        return schema != null && schema.getType() == Schema.Type.ENUM;
    }

    public static <T extends Enum<T>> Class<T> knownEnumType(Schema schema) {
        if (!AvroSchemaUtils.isEnum(schema)) {
            return null;
        }
        String type = schema.getProp("dflib.enum.type");
        if (type == null) {
            return null;
        }
        return AvroSchemaUtils.enumTypeForName(type);
    }

    public static boolean isUnmapped(Schema schema) {
        if (schema == null) {
            return false;
        }
        LogicalType t = schema.getLogicalType();
        return t != null && t.getName().equals(AvroTypeExtensions.UNMAPPED_TYPE.getName());
    }

    private static <T extends Enum<T>> Class<T> enumTypeForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

