/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.dflib.avro.types.SingleSchemaConversion;

public class BigDecimalConversion
extends SingleSchemaConversion<BigDecimal> {
    static final String NAME = "dflib-bigdecimal";

    public BigDecimalConversion() {
        super(NAME, Schema.Type.BYTES);
    }

    public Class<BigDecimal> getConvertedType() {
        return BigDecimal.class;
    }

    public BigDecimal fromBytes(ByteBuffer value, Schema schema, LogicalType type) {
        int scale = value.getInt();
        int len = value.getInt();
        byte[] numbers = new byte[len];
        value.get(numbers);
        return new BigDecimal(new BigInteger(numbers), scale);
    }

    public ByteBuffer toBytes(BigDecimal value, Schema schema, LogicalType type) {
        byte[] numbers = value.unscaledValue().toByteArray();
        int scale = value.scale();
        ByteBuffer buffer = ByteBuffer.allocate(numbers.length + 8);
        buffer.putInt(scale);
        buffer.putInt(numbers.length);
        buffer.put(numbers);
        buffer.flip();
        return buffer;
    }
}

