/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro.types;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.dflib.avro.types.SingleSchemaConversion;

public class BigIntegerConversion
extends SingleSchemaConversion<BigInteger> {
    static final String NAME = "dflib-biginteger";

    public BigIntegerConversion() {
        super(NAME, Schema.Type.BYTES);
    }

    public Class<BigInteger> getConvertedType() {
        return BigInteger.class;
    }

    public BigInteger fromBytes(ByteBuffer value, Schema schema, LogicalType type) {
        int len = value.limit() - value.position();
        byte[] bytes = new byte[len];
        value.get(bytes);
        return new BigInteger(bytes);
    }

    public ByteBuffer toBytes(BigInteger value, Schema schema, LogicalType type) {
        return ByteBuffer.wrap(value.toByteArray());
    }
}

