/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro.types;

import java.nio.ByteBuffer;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.dflib.avro.types.SingleSchemaConversion;

public class ByteArrayConversion
extends SingleSchemaConversion<byte[]> {
    static final String NAME = "dflib-bytearray";

    public ByteArrayConversion() {
        super(NAME, Schema.Type.BYTES);
    }

    public Class<byte[]> getConvertedType() {
        return byte[].class;
    }

    public byte[] fromBytes(ByteBuffer value, Schema schema, LogicalType type) {
        int pos = value.position();
        int limit = value.limit();
        byte[] bytes = new byte[limit - pos];
        value.get(bytes);
        return bytes;
    }

    public ByteBuffer toBytes(byte[] value, Schema schema, LogicalType type) {
        return ByteBuffer.wrap(value);
    }
}

