/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro.types;

import java.nio.ByteBuffer;
import java.time.Duration;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.dflib.avro.types.SingleSchemaConversion;

public class DurationConversion
extends SingleSchemaConversion<Duration> {
    static final String NAME = "dflib-duration";

    public DurationConversion() {
        super(NAME, Schema.Type.BYTES);
    }

    public Class<Duration> getConvertedType() {
        return Duration.class;
    }

    public Duration fromBytes(ByteBuffer value, Schema schema, LogicalType type) {
        long sec = value.getLong();
        int nano = value.getInt();
        return Duration.ofSeconds(sec, nano);
    }

    public ByteBuffer toBytes(Duration value, Schema schema, LogicalType type) {
        ByteBuffer buffer = ByteBuffer.allocate(12);
        long secs = value.getSeconds();
        int nanos = value.getNano();
        buffer.putLong(secs);
        buffer.putInt(nanos);
        buffer.flip();
        return buffer;
    }
}

