/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro.types;

import java.time.LocalDate;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.dflib.avro.types.SingleSchemaConversion;

public class LocalDateConversion
extends SingleSchemaConversion<LocalDate> {
    static final String NAME = "dflib-localdate";

    public LocalDateConversion() {
        super(NAME, Schema.Type.LONG);
    }

    public Class<LocalDate> getConvertedType() {
        return LocalDate.class;
    }

    public LocalDate fromLong(Long value, Schema schema, LogicalType type) {
        return LocalDate.ofEpochDay(value);
    }

    public Long toLong(LocalDate value, Schema schema, LogicalType type) {
        return value.toEpochDay();
    }
}

