/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro.types;

import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.dflib.avro.types.SingleSchemaConversion;

public class LocalDateTimeConversion
extends SingleSchemaConversion<LocalDateTime> {
    static final String NAME = "dflib-localdatetime";

    public LocalDateTimeConversion() {
        super(NAME, Schema.Type.BYTES);
    }

    public Class<LocalDateTime> getConvertedType() {
        return LocalDateTime.class;
    }

    public LocalDateTime fromBytes(ByteBuffer value, Schema schema, LogicalType type) {
        long sec = value.getLong();
        int nano = value.getInt();
        return LocalDateTime.ofEpochSecond(sec, nano, ZoneOffset.UTC);
    }

    public ByteBuffer toBytes(LocalDateTime value, Schema schema, LogicalType type) {
        ByteBuffer buffer = ByteBuffer.allocate(12);
        long secs = value.toEpochSecond(ZoneOffset.UTC);
        int nanos = value.getNano();
        buffer.putLong(secs);
        buffer.putInt(nanos);
        buffer.flip();
        return buffer;
    }
}

