/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro.types;

import java.time.LocalTime;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.dflib.avro.types.SingleSchemaConversion;

public class LocalTimeConversion
extends SingleSchemaConversion<LocalTime> {
    static final String NAME = "dflib-localtime";

    public LocalTimeConversion() {
        super(NAME, Schema.Type.LONG);
    }

    public Class<LocalTime> getConvertedType() {
        return LocalTime.class;
    }

    public LocalTime fromLong(Long value, Schema schema, LogicalType type) {
        return LocalTime.ofNanoOfDay(value);
    }

    public Long toLong(LocalTime value, Schema schema, LogicalType type) {
        return value.toNanoOfDay();
    }
}

