/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro.types;

import java.util.Objects;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;

public class SingleSchemaLogicalType
extends LogicalType {
    private final Schema.Type avroType;

    public SingleSchemaLogicalType(String name, Schema.Type avroType) {
        super(name);
        this.avroType = Objects.requireNonNull(avroType);
    }

    public Schema getRecommendedSchema() {
        return this.addToSchema(Schema.create((Schema.Type)this.avroType));
    }

    public void validate(Schema schema) {
        super.validate(schema);
        if (schema.getType() != this.avroType) {
            throw new IllegalArgumentException("Logical type '" + this.getName() + "' must be backed by '" + this.avroType.getName() + "'");
        }
    }
}

