/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.avro.types;

import java.time.YearMonth;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.dflib.avro.types.SingleSchemaConversion;

public class YearMonthConversion
extends SingleSchemaConversion<YearMonth> {
    static final String NAME = "dflib-yearmonth";

    public YearMonthConversion() {
        super(NAME, Schema.Type.LONG);
    }

    public Class<YearMonth> getConvertedType() {
        return YearMonth.class;
    }

    public YearMonth fromLong(Long value, Schema schema, LogicalType type) {
        long v = value;
        int year = (int)(v >> 32);
        int month = (int)v;
        return YearMonth.of(year, month);
    }

    public Long toLong(YearMonth value, Schema schema, LogicalType type) {
        return (long)value.getYear() << 32 | (long)value.getMonthValue() & 0xFFFFFFFFL;
    }
}

