/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet;

import java.io.File;
import java.nio.file.Path;
import org.apache.parquet.schema.MessageType;
import org.dflib.DataFrame;
import org.dflib.parquet.ParquetLoader;
import org.dflib.parquet.ParquetSaver;
import org.dflib.parquet.ParquetSchemaLoader;

public class Parquet {
    public static DataFrame load(File file) {
        return Parquet.loader().load(file);
    }

    public static DataFrame load(Path filePath) {
        return Parquet.loader().load(filePath);
    }

    public static DataFrame load(String filePath) {
        return Parquet.loader().load(filePath);
    }

    public static MessageType loadSchema(File file) {
        return Parquet.schemaLoader().load(file);
    }

    public static MessageType loadSchema(Path filePath) {
        return Parquet.schemaLoader().load(filePath);
    }

    public static MessageType loadSchema(String filePath) {
        return Parquet.schemaLoader().load(filePath);
    }

    public static void save(DataFrame df, Path filePath) {
        Parquet.saver().save(df, filePath);
    }

    public static void save(DataFrame df, String filePath) {
        Parquet.saver().save(df, filePath);
    }

    public static void save(DataFrame df, File file) {
        Parquet.saver().save(df, file);
    }

    public static ParquetSaver saver() {
        return new ParquetSaver();
    }

    public static ParquetLoader loader() {
        return new ParquetLoader();
    }

    public static ParquetSchemaLoader schemaLoader() {
        return new ParquetSchemaLoader();
    }
}

