/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.LocalInputFile;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.dflib.DataFrame;
import org.dflib.Extractor;
import org.dflib.Index;
import org.dflib.builder.DataFrameArrayAppender;
import org.dflib.builder.DataFrameArrayByRowBuilder;
import org.dflib.parquet.Parquet;
import org.dflib.parquet.read.DataFrameParquetReaderBuilder;
import org.dflib.parquet.read.RowExtractorFactory;
import org.dflib.parquet.read.SchemaProjector;

public class ParquetLoader {
    private SchemaProjector schemaProjector;

    public ParquetLoader cols(String ... columns) {
        this.schemaProjector = SchemaProjector.ofCols(columns);
        return this;
    }

    public ParquetLoader cols(int ... columns) {
        this.schemaProjector = SchemaProjector.ofCols(columns);
        return this;
    }

    public ParquetLoader colsExcept(String ... columns) {
        this.schemaProjector = SchemaProjector.ofColsExcept(columns);
        return this;
    }

    public ParquetLoader colsExcept(int ... columns) {
        this.schemaProjector = SchemaProjector.ofColsExcept(columns);
        return this;
    }

    public DataFrame load(File file) {
        return this.load(file.toPath());
    }

    public DataFrame load(String filePath) {
        return this.load(new File(filePath));
    }

    public DataFrame load(Path filePath) {
        try {
            Object[] row;
            MessageType fileSchema = Parquet.schemaLoader().load(filePath);
            MessageType projectedSchema = this.projectSchema(fileSchema);
            DataFrameArrayAppender appender = ((DataFrameArrayByRowBuilder)DataFrame.byArrayRow(this.mapColumns((GroupType)projectedSchema)).columnIndex(this.createIndex((GroupType)projectedSchema))).appender();
            LocalInputFile inputFile = new LocalInputFile(filePath);
            ParquetReader reader = new DataFrameParquetReaderBuilder((InputFile)inputFile, projectedSchema).build();
            while ((row = (Object[])reader.read()) != null) {
                appender.append((Object)row);
            }
            return appender.toDataFrame();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private MessageType projectSchema(MessageType schema) {
        return this.schemaProjector != null ? this.schemaProjector.project(schema) : schema;
    }

    private Index createIndex(GroupType schema) {
        String[] labels = (String[])schema.getFields().stream().map(Type::getName).toArray(String[]::new);
        return Index.of((String[])labels);
    }

    private Extractor<Object[], ?>[] mapColumns(GroupType schema) {
        List fields = schema.getFields();
        Extractor[] extractors = new Extractor[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            extractors[i] = RowExtractorFactory.converterFor((Type)fields.get(i), i);
        }
        return extractors;
    }
}

