/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet.read;

import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.dflib.Extractor;

public class RowExtractorFactory {
    public static Extractor<Object[], ?> converterFor(Type schemaField, int idx) {
        Extractor<Object[], ?> converter = RowExtractorFactory.buildFromLogicalTypeConverter(schemaField, idx);
        if (converter != null) {
            return converter;
        }
        if (schemaField.isPrimitive()) {
            return RowExtractorFactory.buildPrimitiveExtractor(schemaField, idx);
        }
        throw new RuntimeException(schemaField.asGroupType().getName() + " deserialization not supported");
    }

    private static Extractor<Object[], ?> buildPrimitiveExtractor(Type parquetField, int idx) {
        PrimitiveType.PrimitiveTypeName type = parquetField.asPrimitiveType().getPrimitiveTypeName();
        if (parquetField.isRepetition(Type.Repetition.OPTIONAL)) {
            return Extractor.$col(r -> r[idx]);
        }
        switch (type) {
            case INT32: {
                return Extractor.$int(r -> (Integer)r[idx]);
            }
            case INT64: {
                return Extractor.$long(r -> (Long)r[idx]);
            }
            case FLOAT: {
                return Extractor.$col(r -> r[idx]);
            }
            case DOUBLE: {
                return Extractor.$double(r -> (Double)r[idx]);
            }
            case BOOLEAN: {
                return Extractor.$bool(r -> (Boolean)r[idx]);
            }
        }
        throw new RuntimeException(type + " deserialization not supported");
    }

    private static Extractor<Object[], ?> buildFromLogicalTypeConverter(Type parquetField, int idx) {
        LogicalTypeAnnotation logicalTypeAnnotation = parquetField.getLogicalTypeAnnotation();
        if (logicalTypeAnnotation == null) {
            return null;
        }
        Extractor defaultExtractor = Extractor.$col(r -> r[idx]);
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.stringType())) {
            return defaultExtractor;
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.enumType())) {
            return defaultExtractor;
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
            LogicalTypeAnnotation.IntLogicalTypeAnnotation intType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation;
            if (intType.getBitWidth() == 8) {
                return defaultExtractor;
            }
            if (intType.getBitWidth() == 16) {
                return defaultExtractor;
            }
        }
        PrimitiveType.PrimitiveTypeName primitiveTypeName = parquetField.asPrimitiveType().getPrimitiveTypeName();
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.uuidType()) && primitiveTypeName == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            return defaultExtractor;
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.dateType()) && primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32) {
            return defaultExtractor;
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation && (primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32 || primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64)) {
            return defaultExtractor;
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation && primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64) {
            return defaultExtractor;
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            return defaultExtractor;
        }
        return null;
    }
}

