/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet;

import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.dflib.Extractor;
import org.dflib.Index;

class ColConfigurator {
    int srcColPos = -1;
    String srcColName;
    boolean compact;

    private ColConfigurator() {
    }

    static ColConfigurator objectCol(int pos, boolean compact) {
        ColConfigurator config = new ColConfigurator();
        config.srcColPos = pos;
        config.compact = compact;
        return config;
    }

    static ColConfigurator objectCol(String name, boolean compact) {
        ColConfigurator config = new ColConfigurator();
        config.srcColName = name;
        config.compact = compact;
        return config;
    }

    int srcPos(Index header) {
        return this.srcColPos >= 0 ? this.srcColPos : header.position(this.srcColName);
    }

    Extractor<Object[], ?> extractor(int srcPos, GroupType schema) {
        Extractor e = ColConfigurator.sparseExtractor(srcPos, (Type)schema.getFields().get(srcPos));
        return this.compact ? e.compact() : e;
    }

    private static Extractor<Object[], ?> sparseExtractor(int pos, Type colSchema) {
        Extractor<Object[], ?> extractor = ColConfigurator.logicalExtractor(pos, colSchema);
        if (extractor != null) {
            return extractor;
        }
        if (colSchema.isPrimitive()) {
            return ColConfigurator.primitiveExtractor(pos, colSchema);
        }
        throw new RuntimeException(colSchema.asGroupType().getName() + " deserialization not supported");
    }

    private static Extractor<Object[], ?> primitiveExtractor(int pos, Type colSchema) {
        PrimitiveType.PrimitiveTypeName type = colSchema.asPrimitiveType().getPrimitiveTypeName();
        if (colSchema.isRepetition(Type.Repetition.OPTIONAL)) {
            return Extractor.$col(r -> r[pos]);
        }
        switch (type) {
            case INT32: {
                return Extractor.$int(r -> (Integer)r[pos]);
            }
            case INT64: {
                return Extractor.$long(r -> (Long)r[pos]);
            }
            case FLOAT: {
                return Extractor.$col(r -> r[pos]);
            }
            case DOUBLE: {
                return Extractor.$double(r -> (Double)r[pos]);
            }
            case BOOLEAN: {
                return Extractor.$bool(r -> (Boolean)r[pos]);
            }
        }
        throw new RuntimeException(type + " deserialization not supported");
    }

    private static Extractor<Object[], ?> logicalExtractor(int pos, Type colSchema) {
        LogicalTypeAnnotation logicalTypeAnnotation = colSchema.getLogicalTypeAnnotation();
        if (logicalTypeAnnotation == null) {
            return null;
        }
        Extractor defaultExtractor = Extractor.$col(r -> r[pos]);
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.stringType())) {
            return defaultExtractor;
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.enumType())) {
            return defaultExtractor;
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
            LogicalTypeAnnotation.IntLogicalTypeAnnotation intType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation;
            if (intType.getBitWidth() == 8) {
                return defaultExtractor;
            }
            if (intType.getBitWidth() == 16) {
                return defaultExtractor;
            }
        }
        PrimitiveType.PrimitiveTypeName primitiveTypeName = colSchema.asPrimitiveType().getPrimitiveTypeName();
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.uuidType()) && primitiveTypeName == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            return defaultExtractor;
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.dateType()) && primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32) {
            return defaultExtractor;
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation && (primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32 || primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64)) {
            return defaultExtractor;
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation && primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64) {
            return defaultExtractor;
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            return defaultExtractor;
        }
        return null;
    }
}

