/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.LocalInputFile;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.dflib.DataFrame;
import org.dflib.Extractor;
import org.dflib.Index;
import org.dflib.builder.DataFrameArrayAppender;
import org.dflib.builder.DataFrameArrayByRowBuilder;
import org.dflib.parquet.ColConfigurator;
import org.dflib.parquet.Parquet;
import org.dflib.parquet.read.DataFrameParquetReaderBuilder;
import org.dflib.parquet.read.SchemaProjector;

public class ParquetLoader {
    private SchemaProjector schemaProjector;
    private final List<ColConfigurator> colConfigurators = new ArrayList<ColConfigurator>();

    public ParquetLoader cols(String ... columns) {
        this.schemaProjector = SchemaProjector.ofCols(columns);
        return this;
    }

    public ParquetLoader cols(int ... columns) {
        this.schemaProjector = SchemaProjector.ofCols(columns);
        return this;
    }

    public ParquetLoader colsExcept(String ... columns) {
        this.schemaProjector = SchemaProjector.ofColsExcept(columns);
        return this;
    }

    public ParquetLoader colsExcept(int ... columns) {
        this.schemaProjector = SchemaProjector.ofColsExcept(columns);
        return this;
    }

    public ParquetLoader compactCol(int column) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, true));
        return this;
    }

    public ParquetLoader compactCol(String column) {
        this.colConfigurators.add(ColConfigurator.objectCol(column, true));
        return this;
    }

    public DataFrame load(File file) {
        return this.load(file.toPath());
    }

    public DataFrame load(String filePath) {
        return this.load(new File(filePath));
    }

    public DataFrame load(Path filePath) {
        try {
            Object[] row;
            MessageType fileSchema = Parquet.schemaLoader().load(filePath);
            MessageType projectedSchema = this.projectSchema(fileSchema);
            Index index = this.createIndex((GroupType)projectedSchema);
            DataFrameArrayAppender appender = ((DataFrameArrayByRowBuilder)DataFrame.byArrayRow(this.extractors(index, (GroupType)projectedSchema)).columnIndex(index)).appender();
            LocalInputFile inputFile = new LocalInputFile(filePath);
            ParquetReader reader = new DataFrameParquetReaderBuilder((InputFile)inputFile, projectedSchema).build();
            while ((row = (Object[])reader.read()) != null) {
                appender.append((Object)row);
            }
            return appender.toDataFrame();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private MessageType projectSchema(MessageType schema) {
        return this.schemaProjector != null ? this.schemaProjector.project(schema) : schema;
    }

    private Index createIndex(GroupType schema) {
        String[] labels = (String[])schema.getFields().stream().map(Type::getName).toArray(String[]::new);
        return Index.of((String[])labels);
    }

    private Extractor<Object[], ?>[] extractors(Index index, GroupType schema) {
        HashMap<Integer, ColConfigurator> configurators = new HashMap<Integer, ColConfigurator>();
        for (ColConfigurator c : this.colConfigurators) {
            configurators.put(c.srcPos(index), c);
        }
        int w = schema.getFields().size();
        Extractor[] extractors = new Extractor[w];
        for (int i = 0; i < w; ++i) {
            ColConfigurator cc = configurators.computeIfAbsent(i, ii -> ColConfigurator.objectCol(ii, false));
            extractors[i] = cc.extractor(i, schema);
        }
        return extractors;
    }
}

