/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.LocalInputFile;
import org.apache.parquet.schema.MessageType;

public class ParquetSchemaLoader {
    public MessageType load(Path filePath) {
        MessageType messageType;
        LocalInputFile inputFile = new LocalInputFile(filePath);
        ParquetReadOptions parquetReadOptions = ParquetReadOptions.builder((ParquetConfiguration)new PlainParquetConfiguration()).build();
        ParquetFileReader parquetFile = new ParquetFileReader((InputFile)inputFile, parquetReadOptions);
        try {
            messageType = parquetFile.getFileMetaData().getSchema();
        }
        catch (Throwable throwable) {
            try {
                try {
                    parquetFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading Parquet schema file: " + filePath, e);
            }
        }
        parquetFile.close();
        return messageType;
    }

    public MessageType load(String filePath) {
        return this.load(new File(filePath));
    }

    public MessageType load(File file) {
        return this.load(file.toPath());
    }
}

