/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet.read.converter;

import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.dflib.parquet.read.converter.DecimalConverter;
import org.dflib.parquet.read.converter.InstantConverter;
import org.dflib.parquet.read.converter.LocalDateConverter;
import org.dflib.parquet.read.converter.LocalDateTimeConverter;
import org.dflib.parquet.read.converter.LocalTimeConverter;
import org.dflib.parquet.read.converter.StringConverter;
import org.dflib.parquet.read.converter.ToByteConverter;
import org.dflib.parquet.read.converter.ToPrimitiveTypeConverter;
import org.dflib.parquet.read.converter.ToShortConverter;
import org.dflib.parquet.read.converter.UuidConverter;

public class RowConverter
extends GroupConverter {
    private final Converter[] converters;
    private final Consumer<Object[]> rowConsumer;
    private final Object[] row;

    public RowConverter(GroupType schema, Consumer<Object[]> rowConsumer) {
        this.rowConsumer = rowConsumer;
        this.converters = new Converter[schema.getFields().size()];
        this.row = new Object[schema.getFields().size()];
        int cont = 0;
        for (Type schemaField : schema.getFields()) {
            this.converters[cont] = this.converterFor(cont, schemaField, this.row);
            ++cont;
        }
    }

    private Converter converterFor(int idx, Type schemaField, Object[] row) {
        Consumer<Object> consumer = value -> {
            row[idx] = value;
        };
        Converter converter = RowConverter.buildFromLogicalTypeConverter(schemaField, consumer);
        if (converter != null) {
            return converter;
        }
        if (schemaField.isPrimitive()) {
            return RowConverter.buildPrimitiveConverters(schemaField, consumer);
        }
        throw new RuntimeException(schemaField.asGroupType().getName() + " deserialization not supported");
    }

    private static Converter buildPrimitiveConverters(Type parquetField, Consumer<Object> consumer) {
        PrimitiveType.PrimitiveTypeName type = parquetField.asPrimitiveType().getPrimitiveTypeName();
        switch (type) {
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return new ToPrimitiveTypeConverter(consumer);
            }
        }
        throw new RuntimeException(type + " deserialization not supported");
    }

    public static Converter buildFromLogicalTypeConverter(Type parquetField, Consumer<Object> consumer) {
        LogicalTypeAnnotation logicalTypeAnnotation = parquetField.getLogicalTypeAnnotation();
        if (logicalTypeAnnotation == null) {
            return null;
        }
        PrimitiveType.PrimitiveTypeName primitiveTypeName = parquetField.asPrimitiveType().getPrimitiveTypeName();
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.stringType())) {
            return new StringConverter(consumer);
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.enumType())) {
            return new StringConverter(consumer);
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
            LogicalTypeAnnotation.IntLogicalTypeAnnotation intType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalTypeAnnotation;
            if (intType.getBitWidth() == 8) {
                return new ToByteConverter(consumer);
            }
            if (intType.getBitWidth() == 16) {
                return new ToShortConverter(consumer);
            }
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.uuidType()) && primitiveTypeName == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            return new UuidConverter(consumer);
        }
        if (logicalTypeAnnotation.equals(LogicalTypeAnnotation.dateType()) && primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32) {
            return new LocalDateConverter(consumer);
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation && (primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32 || primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64)) {
            LogicalTypeAnnotation.TimeLogicalTypeAnnotation time = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)logicalTypeAnnotation;
            return new LocalTimeConverter(consumer, time.getUnit());
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation && primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64) {
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStamp = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
            if (timeStamp.isAdjustedToUTC()) {
                return new InstantConverter(consumer, timeStamp.getUnit());
            }
            return new LocalDateTimeConverter(consumer, timeStamp.getUnit());
        }
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation;
            return new DecimalConverter(consumer, primitiveTypeName, decimalType.getScale());
        }
        return null;
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public void start() {
        Arrays.fill(this.row, null);
    }

    public void end() {
        this.rowConsumer.accept(this.row);
    }
}

