/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet.write;

import java.time.Instant;
import org.dflib.parquet.TimeUnit;

class InstantWrite {
    InstantWrite() {
    }

    static InstantToLong getInstantMapper(TimeUnit timeUnit) {
        switch (timeUnit) {
            case MILLIS: {
                return InstantWrite::millisFromEpochFromInstant;
            }
            case MICROS: {
                return InstantWrite::microsFromEpochFromInstant;
            }
            case NANOS: {
                return InstantWrite::nanosFromEpochFromInstant;
            }
        }
        throw new IllegalArgumentException("Invalid " + timeUnit);
    }

    static long millisFromEpochFromInstant(Instant instant) {
        return instant.toEpochMilli();
    }

    static long microsFromEpochFromInstant(Instant instant) {
        long seconds = instant.getEpochSecond();
        int nanos = instant.getNano();
        if (seconds < 0L && nanos > 0) {
            long micros = Math.multiplyExact(seconds + 1L, 1000000L);
            long adjustment = (long)nanos / 1000L - 1000000L;
            return Math.addExact(micros, adjustment);
        }
        long micros = Math.multiplyExact(seconds, 1000000L);
        return Math.addExact(micros, (long)nanos / 1000L);
    }

    static long nanosFromEpochFromInstant(Instant instant) {
        long seconds = instant.getEpochSecond();
        int nanos = instant.getNano();
        if (seconds < 0L && nanos > 0) {
            long micros = Math.multiplyExact(seconds + 1L, 1000000000L);
            long adjustment = (long)nanos - 1000000000L;
            return Math.addExact(micros, adjustment);
        }
        long micros = Math.multiplyExact(seconds, 1000000000L);
        return Math.addExact(micros, (long)nanos);
    }

    @FunctionalInterface
    public static interface InstantToLong {
        public long map(Instant var1);
    }
}

