/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet.write;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.dflib.parquet.write.DecimalConfig;

class BigDecimalWrite {
    private final int precision;
    private final int scale;
    private final DecimalMapper mapper;

    public BigDecimalWrite(DecimalConfig decimalConfig) {
        this.precision = decimalConfig.getPrecision();
        this.scale = decimalConfig.getScale();
        this.mapper = this.calcMapper(decimalConfig.getPrecision());
    }

    void write(RecordConsumer recordConsumer, Object value) {
        BigDecimal dec = this.rescaleIfPossible((BigDecimal)value);
        switch (this.mapper.ordinal()) {
            case 0: {
                recordConsumer.addInteger(dec.unscaledValue().intValue());
                break;
            }
            case 1: {
                recordConsumer.addLong(dec.unscaledValue().longValue());
                break;
            }
            case 2: {
                byte[] a = dec.unscaledValue().toByteArray();
                recordConsumer.addBinary(Binary.fromConstantByteArray((byte[])a));
            }
        }
    }

    private DecimalMapper calcMapper(int precision) {
        if (precision <= 9) {
            return DecimalMapper.INT;
        }
        if (precision <= 18) {
            return DecimalMapper.LONG;
        }
        return DecimalMapper.BINARY;
    }

    private BigDecimal rescaleIfPossible(BigDecimal value) {
        int valuePrecision;
        int valueScale = value.scale();
        boolean scaleAdjusted = false;
        if (valueScale != this.scale) {
            try {
                value = value.setScale(this.scale, RoundingMode.UNNECESSARY);
                scaleAdjusted = true;
            }
            catch (ArithmeticException aex) {
                throw new IllegalArgumentException("Cannot encode BigDecimal with scale " + valueScale + " as scale " + this.scale + " without rounding");
            }
        }
        if ((valuePrecision = value.precision()) > this.precision) {
            if (scaleAdjusted) {
                throw new IllegalArgumentException("Cannot encode BigDecimal with precision " + valuePrecision + " as max precision " + this.precision + ". This is after safely adjusting scale from " + valueScale + " to required " + this.scale);
            }
            throw new IllegalArgumentException("Cannot encode BigDecimal with precision " + valuePrecision + " as max precision " + this.precision);
        }
        return value;
    }

    static enum DecimalMapper {
        INT,
        LONG,
        BINARY;

    }
}

