/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.LocalInputFile;
import org.apache.parquet.schema.MessageType;
import org.dflib.ByteSource;
import org.dflib.parquet.read.BytesInputFile;

public class ParquetSchemaLoader {
    public MessageType load(Path filePath) {
        return this.loadFromInputFile((InputFile)new LocalInputFile(filePath), filePath::toString);
    }

    public MessageType load(String filePath) {
        return this.load(new File(filePath));
    }

    public MessageType load(File file) {
        return this.load(file.toPath());
    }

    public MessageType load(ByteSource src) {
        return this.load(src.asBytes());
    }

    public MessageType load(byte[] bytes) {
        return this.loadFromInputFile(new BytesInputFile(bytes), () -> "?");
    }

    private MessageType loadFromInputFile(InputFile inputFile, Supplier<String> resourceId) {
        MessageType messageType;
        ParquetReadOptions parquetReadOptions = ParquetReadOptions.builder((ParquetConfiguration)new PlainParquetConfiguration()).build();
        ParquetFileReader parquetFile = new ParquetFileReader(inputFile, parquetReadOptions);
        try {
            messageType = parquetFile.getFileMetaData().getSchema();
        }
        catch (Throwable throwable) {
            try {
                try {
                    parquetFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading Parquet schema file: " + resourceId.get(), e);
            }
        }
        parquetFile.close();
        return messageType;
    }
}

