/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet.read;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class BytesInputFile
implements InputFile {
    private final byte[] data;

    public BytesInputFile(byte[] data) {
        this.data = data;
    }

    public long getLength() {
        return this.data.length;
    }

    public SeekableInputStream newStream() {
        return new SeekableInputStream(){
            private final ByteArrayInputStream in;
            {
                this.in = new ByteArrayInputStream(BytesInputFile.this.data);
            }

            public long getPos() {
                return BytesInputFile.this.data.length - this.in.available();
            }

            public void seek(long newPos) {
                this.in.reset();
                this.in.skip(newPos);
            }

            public int read() {
                return this.in.read();
            }

            public int read(ByteBuffer buf) throws IOException {
                byte[] buffer = new byte[buf.remaining()];
                int code = this.read(buffer);
                buf.put(buffer, buf.position() + buf.arrayOffset(), buf.remaining());
                return code;
            }

            public void readFully(byte[] bytes) throws IOException {
                this.readFully(bytes, 0, bytes.length);
            }

            public void readFully(byte[] bytes, int start, int len) throws IOException {
                int count;
                int read = 0;
                do {
                    if ((count = this.in.read(bytes, read, len - read)) >= 0) continue;
                    throw new EOFException();
                } while ((read += count) < len);
            }

            public void readFully(ByteBuffer buf) throws IOException {
                byte[] buffer = new byte[buf.remaining()];
                this.readFully(buffer);
                buf.put(buffer, buf.position() + buf.arrayOffset(), buf.remaining());
            }
        };
    }
}

