/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet.read;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.dflib.parquet.read.converter.RowConverter;

class DataFrameReadSupport
extends ReadSupport<Object[]> {
    private final MessageType projection;

    DataFrameReadSupport(MessageType projection) {
        this.projection = projection;
    }

    public RecordMaterializer<Object[]> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new DataFrameMaterializer(readContext.getRequestedSchema());
    }

    public ReadSupport.ReadContext init(InitContext initContext) {
        LinkedHashMap metadata = new LinkedHashMap();
        return new ReadSupport.ReadContext(this.projection, metadata);
    }

    private static class DataFrameMaterializer
    extends RecordMaterializer<Object[]> {
        private final GroupConverter root;
        private Object[] value;

        public DataFrameMaterializer(MessageType requestedSchema) {
            this.root = new RowConverter((GroupType)requestedSchema, v -> {
                this.value = v;
            });
        }

        public Object[] getCurrentRecord() {
            return this.value;
        }

        public GroupConverter getRootConverter() {
            return this.root;
        }
    }
}

