/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet.read;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

@FunctionalInterface
public interface SchemaProjector {
    public MessageType project(MessageType var1);

    public static SchemaProjector ofCols(int ... columns) {
        return ch -> SchemaProjector.positions(ch, columns);
    }

    public static SchemaProjector ofCols(String ... columns) {
        return ch -> SchemaProjector.labels(ch, columns);
    }

    public static SchemaProjector ofColsExcept(int ... columns) {
        return ch -> SchemaProjector.positionsExcept(ch, columns);
    }

    public static SchemaProjector ofColsExcept(String ... columns) {
        return ch -> SchemaProjector.labelsExcept(ch, columns);
    }

    private static MessageType positions(MessageType schema, int[] columns) {
        int w = columns.length;
        ArrayList<Type> projection = new ArrayList<Type>(w);
        for (int i = 0; i < w; ++i) {
            projection.add(schema.getType(schema.getFieldName(columns[i])));
        }
        return new MessageType(schema.getName(), projection);
    }

    private static MessageType labels(MessageType schema, String[] columns) {
        int w = columns.length;
        ArrayList<Type> projection = new ArrayList<Type>(w);
        for (int i = 0; i < w; ++i) {
            projection.add(schema.getType(columns[i]));
        }
        return new MessageType(schema.getName(), projection);
    }

    private static MessageType positionsExcept(MessageType schema, int[] columns) {
        int w = columns.length;
        if (w == 0) {
            return schema;
        }
        HashSet<Integer> excludes = new HashSet<Integer>((int)Math.ceil((double)w / 0.75));
        for (int e : columns) {
            excludes.add(e);
        }
        int len = schema.getFieldCount();
        int[] positions = new int[len - excludes.size()];
        int ii = 0;
        for (int i = 0; i < len; ++i) {
            if (excludes.contains(i)) continue;
            positions[ii++] = i;
        }
        return SchemaProjector.positions(schema, positions);
    }

    private static MessageType labelsExcept(MessageType schema, String[] columns) {
        int w = columns.length;
        if (w == 0) {
            return schema;
        }
        HashSet<String> excludes = new HashSet<String>((int)Math.ceil((double)w / 0.75));
        for (String e : columns) {
            excludes.add(e);
        }
        ArrayList<Type> projection = new ArrayList<Type>();
        for (Type t : schema.getFields()) {
            if (excludes.contains(t.getName())) continue;
            projection.add(t);
        }
        return new MessageType(schema.getName(), projection);
    }
}

