/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet.read.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.PrimitiveType;

class DecimalConverter
extends PrimitiveConverter {
    private final Consumer<Object> consumer;
    private final PrimitiveType.PrimitiveTypeName type;
    private final int scale;
    private BigDecimal[] dict = null;

    public DecimalConverter(Consumer<Object> consumer, PrimitiveType.PrimitiveTypeName type, int scale) {
        this.consumer = consumer;
        this.scale = scale;
        this.type = type;
    }

    public void addBinary(Binary value) {
        this.consumer.accept(this.convert(value));
    }

    public void addInt(int value) {
        this.consumer.accept(this.convert(value));
    }

    public void addLong(long value) {
        this.consumer.accept(this.convert(value));
    }

    public void addValueFromDictionary(int dictionaryId) {
        this.consumer.accept(this.dict[dictionaryId]);
    }

    public boolean hasDictionarySupport() {
        return true;
    }

    public void setDictionary(Dictionary dictionary) {
        block4: {
            int maxId;
            block5: {
                block3: {
                    maxId = dictionary.getMaxId();
                    this.dict = new BigDecimal[maxId + 1];
                    if (this.type != PrimitiveType.PrimitiveTypeName.INT32) break block3;
                    for (int i = 0; i <= maxId; ++i) {
                        this.dict[i] = this.convert(dictionary.decodeToInt(i));
                    }
                    break block4;
                }
                if (this.type != PrimitiveType.PrimitiveTypeName.INT64) break block5;
                for (int i = 0; i <= maxId; ++i) {
                    this.dict[i] = this.convert(dictionary.decodeToLong(i));
                }
                break block4;
            }
            if (this.type != PrimitiveType.PrimitiveTypeName.BINARY && this.type != PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) break block4;
            for (int i = 0; i <= maxId; ++i) {
                this.dict[i] = this.convert(dictionary.decodeToBinary(i));
            }
        }
    }

    private BigDecimal convert(Binary binary) {
        ByteBuffer value = ByteBuffer.wrap(binary.getBytes());
        byte[] bytes = new byte[value.remaining()];
        value.duplicate().get(bytes);
        return new BigDecimal(new BigInteger(bytes), this.scale);
    }

    private BigDecimal convert(long value) {
        return BigDecimal.valueOf(value, this.scale);
    }
}

