/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet.write;

import java.util.ArrayList;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.dflib.parquet.TimeUnit;
import org.dflib.parquet.write.ColumnMeta;
import org.dflib.parquet.write.DataFrameSchema;
import org.dflib.parquet.write.DecimalConfig;
import org.dflib.parquet.write.WriteConfiguration;

class ParquetSchemaCompiler {
    private static final String DEFAULT_NAME = "DataFrame";
    private final WriteConfiguration writeConfiguration;

    public ParquetSchemaCompiler(WriteConfiguration writeConfiguration) {
        this.writeConfiguration = writeConfiguration;
    }

    public MessageType compileSchema(DataFrameSchema dataFrameSchema) {
        ArrayList<Type> fields = new ArrayList<Type>();
        for (ColumnMeta column : dataFrameSchema.getColumns()) {
            Type field = this.createSchemaField(column);
            fields.add(field);
        }
        return new MessageType(DEFAULT_NAME, fields);
    }

    private Type createSchemaField(ColumnMeta column) {
        String name;
        String columnName = column.getColumnName();
        if (column.isEnum()) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType())).named(columnName);
        }
        switch (name = column.getInferredTypeName()) {
            case "int": {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named(columnName);
            }
            case "java.lang.Integer": {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.OPTIONAL).named(columnName);
            }
            case "long": {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named(columnName);
            }
            case "java.lang.Long": {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.OPTIONAL).named(columnName);
            }
            case "java.lang.Byte": {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true))).named(columnName);
            }
            case "java.lang.Short": {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true))).named(columnName);
            }
            case "java.lang.Float": {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)Type.Repetition.OPTIONAL).named(columnName);
            }
            case "double": {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).named(columnName);
            }
            case "java.lang.Double": {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.OPTIONAL).named(columnName);
            }
            case "boolean": {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)Type.Repetition.REQUIRED).named(columnName);
            }
            case "java.lang.Boolean": {
                return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)Type.Repetition.OPTIONAL).named(columnName);
            }
            case "java.lang.String": {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(columnName);
            }
            case "java.util.UUID": {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.uuidType())).length(16)).named(columnName);
            }
            case "java.time.LocalDate": {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named(columnName);
            }
            case "java.time.LocalTime": {
                return this.localTime(columnName, this.writeConfiguration.getTimeUnit());
            }
            case "java.time.LocalDateTime": {
                return this.localDateTime(columnName, this.writeConfiguration.getTimeUnit());
            }
            case "java.time.Instant": {
                return this.instant(columnName, this.writeConfiguration.getTimeUnit());
            }
            case "java.math.BigDecimal": {
                return this.decimalTypeItem(columnName, this.writeConfiguration.getDecimalConfig());
            }
        }
        throw new RuntimeException(name + " not supported in Parquet");
    }

    private PrimitiveType localTime(String columnName, TimeUnit timeUnit) {
        LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeType = LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)ParquetSchemaCompiler.toParquetTimeUnit(timeUnit));
        PrimitiveType.PrimitiveTypeName typeName = PrimitiveType.PrimitiveTypeName.INT64;
        if (timeUnit == TimeUnit.MILLIS) {
            typeName = PrimitiveType.PrimitiveTypeName.INT32;
        }
        return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)typeName, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)timeType)).named(columnName);
    }

    private PrimitiveType localDateTime(String columnName, TimeUnit timeUnit) {
        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStampType = LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)ParquetSchemaCompiler.toParquetTimeUnit(timeUnit));
        return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)timeStampType)).named(columnName);
    }

    private PrimitiveType instant(String columnName, TimeUnit timeUnit) {
        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStampType = LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)ParquetSchemaCompiler.toParquetTimeUnit(timeUnit));
        return (PrimitiveType)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)timeStampType)).named(columnName);
    }

    private static LogicalTypeAnnotation.TimeUnit toParquetTimeUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case MILLIS: {
                return LogicalTypeAnnotation.TimeUnit.MILLIS;
            }
            case MICROS: {
                return LogicalTypeAnnotation.TimeUnit.MICROS;
            }
            case NANOS: {
                return LogicalTypeAnnotation.TimeUnit.NANOS;
            }
        }
        return LogicalTypeAnnotation.TimeUnit.MICROS;
    }

    private Type decimalTypeItem(String name, DecimalConfig decimalConfig) {
        if (decimalConfig == null) {
            throw new RuntimeException("If BigDecimall is used, a Default Decimal configuration must be provided in the setup of ParquetSaver");
        }
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = LogicalTypeAnnotation.decimalType((int)decimalConfig.getScale(), (int)decimalConfig.getPrecision());
        if (decimalConfig.getPrecision() <= 9) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)decimalType)).named(name);
        }
        if (decimalConfig.getPrecision() <= 18) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)decimalType)).named(name);
        }
        return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)decimalType)).named(name);
    }
}

