/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.circe;

import io.circe.Json;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Map;
import org.dhallj.circe.CirceHandler;
import org.dhallj.core.Expr;
import org.dhallj.core.Visitor;
import org.dhallj.core.converters.JsonConverter;
import org.dhallj.core.converters.JsonHandler;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.LambdaDeserialize;

public final class Converter$ {
    public static final Converter$ MODULE$ = new Converter$();
    private static final Json.Folder<Expr> folder = new Json.Folder<Expr>(){

        public Expr onBoolean(boolean value) {
            return value ? Expr.Constants.TRUE : Expr.Constants.FALSE;
        }

        public Expr onNull() {
            return Expr.makeApplication((Expr)Expr.Constants.NONE, (Expr)Expr.Constants.EMPTY_RECORD_TYPE);
        }

        public Expr onNumber(JsonNumber value) {
            Expr expr;
            double asDouble = value.toDouble();
            if (Double.compare(asDouble, -0.0) == 0) {
                expr = Expr.makeDoubleLiteral((double)asDouble);
            } else {
                Expr expr2;
                Option option = value.toBigInt();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BigInt integer = (BigInt)some.value();
                    expr2 = integer.underlying().compareTo(BigInteger.ZERO) > 0 ? Expr.makeNaturalLiteral((BigInteger)integer.underlying()) : Expr.makeIntegerLiteral((BigInteger)integer.underlying());
                } else if (None$.MODULE$.equals(option)) {
                    expr2 = Expr.makeDoubleLiteral((double)asDouble);
                } else {
                    throw new MatchError((Object)option);
                }
                expr = expr2;
            }
            return expr;
        }

        public Expr onString(String value) {
            return Expr.makeTextLiteral((String)value);
        }

        public Expr onObject(JsonObject value) {
            return Expr.makeRecordLiteral((Map.Entry[])((Map.Entry[])((IterableOnceOps)value.toMap().map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Json v = (Json)tuple2._2();
                AbstractMap.SimpleImmutableEntry<String, Object> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<String, Object>(k, v.foldWith((Json.Folder)this));
                return simpleImmutableEntry;
            })).toArray(ClassTag$.MODULE$.apply(Map.Entry.class))));
        }

        public Expr onArray(Vector<Json> value) {
            return value.isEmpty() ? Expr.makeEmptyListLiteral((Expr)Expr.makeApplication((Expr)Expr.Constants.LIST, (Expr)Expr.Constants.EMPTY_RECORD_TYPE)) : Expr.makeNonEmptyListLiteral((Expr[])((Expr[])((IterableOnceOps)value.map((Function1 & Serializable)x$1 -> (Expr)x$1.foldWith((Json.Folder)this))).toArray(ClassTag$.MODULE$.apply(Expr.class))));
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onArray$1(org.dhallj.circe.Converter$$anon$1 io.circe.Json ), $anonfun$onObject$1(org.dhallj.circe.Converter$$anon$1 scala.Tuple2 )}, serializedLambda);
        }
    };

    public Option<Json> apply(Expr expr) {
        CirceHandler handler = new CirceHandler();
        Boolean wasConverted = (Boolean)expr.accept((Visitor)new JsonConverter((JsonHandler)handler, false));
        return Predef$.MODULE$.Boolean2boolean(wasConverted) ? new Some((Object)handler.result()) : None$.MODULE$;
    }

    public Expr apply(Json json) {
        return (Expr)json.foldWith(folder);
    }

    private Converter$() {
    }
}

