/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.circe;

import io.circe.Json;
import io.circe.Json$;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import org.dhallj.circe.ArrayContext;
import org.dhallj.circe.Context;
import org.dhallj.circe.ObjectContext;
import org.dhallj.circe.RootContext;
import org.dhallj.core.converters.JsonHandler;
import scala.math.BigInt;

public class CirceHandler
implements JsonHandler {
    private final Deque<Context> stack = new ArrayDeque<Context>();

    public void addValue(Json value) {
        if (this.stack.isEmpty()) {
            this.stack.push(new RootContext(value));
        } else {
            this.stack.peek().add(value);
        }
    }

    public final Json result() {
        return this.stack.pop().result();
    }

    public final void onNull() {
        this.addValue(Json$.MODULE$.Null());
    }

    public final void onBoolean(boolean value) {
        this.addValue(value ? Json$.MODULE$.True() : Json$.MODULE$.False());
    }

    public final void onNumber(BigInteger value) {
        this.addValue(Json$.MODULE$.fromBigInt(new BigInt(value)));
    }

    public void onDouble(double value) {
        this.addValue(Json$.MODULE$.fromDoubleOrNull(value));
    }

    public final void onString(String value) {
        this.addValue(Json$.MODULE$.fromString(value));
    }

    public final void onArrayStart() {
        this.stack.push(new ArrayContext());
    }

    public final void onArrayEnd() {
        Context current = this.stack.pop();
        if (this.stack.isEmpty()) {
            this.stack.push(current);
        } else {
            this.stack.peek().add(current.result());
        }
    }

    public final void onArrayElementGap() {
    }

    public final void onObjectStart() {
        this.stack.push(new ObjectContext());
    }

    public final void onObjectEnd() {
        Context current = this.stack.pop();
        if (this.stack.isEmpty()) {
            this.stack.push(current);
        } else {
            this.stack.peek().add(current.result());
        }
    }

    public final void onObjectField(String name) {
        this.stack.peek().add(name);
    }

    public final void onObjectFieldGap() {
    }
}

