/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.circe;

import io.circe.Json;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Map;
import org.dhallj.circe.CirceHandler;
import org.dhallj.core.Expr;
import org.dhallj.core.Visitor;
import org.dhallj.core.converters.JsonConverter;
import org.dhallj.core.converters.JsonHandler;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;

public final class Converter$
implements Serializable {
    private static final Json.Folder<Expr> folder;
    public static final Converter$ MODULE$;

    private Converter$() {
    }

    static {
        MODULE$ = new Converter$();
        folder = new Json.Folder<Expr>(){

            public Expr onBoolean(boolean value) {
                return value ? Expr.Constants.TRUE : Expr.Constants.FALSE;
            }

            public Expr onNull() {
                return Expr.makeApplication((Expr)Expr.Constants.NONE, (Expr)Expr.Constants.EMPTY_RECORD_TYPE);
            }

            public Expr onNumber(JsonNumber value) {
                Expr expr;
                double asDouble = value.toDouble();
                if (Double.compare(asDouble, -0.0) == 0) {
                    expr = Expr.makeDoubleLiteral((double)asDouble);
                } else {
                    Option option = value.toBigInt();
                    if (option instanceof Some) {
                        BigInt integer = (BigInt)((Some)option).value();
                        expr = integer.underlying().compareTo(BigInteger.ZERO) > 0 ? Expr.makeNaturalLiteral((BigInteger)integer.underlying()) : Expr.makeIntegerLiteral((BigInteger)integer.underlying());
                    } else if (None$.MODULE$.equals(option)) {
                        expr = Expr.makeDoubleLiteral((double)asDouble);
                    } else {
                        throw new MatchError((Object)option);
                    }
                }
                return expr;
            }

            public Expr onString(String value) {
                return Expr.makeTextLiteral((String)value);
            }

            public Expr onObject(JsonObject value) {
                return Expr.makeRecordLiteral((Map.Entry[])((Map.Entry[])((IterableOnceOps)value.toMap().map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String k = (String)tuple2._1();
                    Json v = (Json)tuple2._2();
                    return new AbstractMap.SimpleImmutableEntry<String, Object>(k, v.foldWith((Json.Folder)this));
                })).toArray(ClassTag$.MODULE$.apply(Map.Entry.class))));
            }

            public Expr onArray(Vector value) {
                return value.isEmpty() ? Expr.makeEmptyListLiteral((Expr)Expr.makeApplication((Expr)Expr.Constants.LIST, (Expr)Expr.Constants.EMPTY_RECORD_TYPE)) : Expr.makeNonEmptyListLiteral((Expr[])((Expr[])((IterableOnceOps)value.map((Function1 & Serializable)_$1 -> (Expr)_$1.foldWith((Json.Folder)this))).toArray(ClassTag$.MODULE$.apply(Expr.class))));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{onObject$$anonfun$1(scala.Tuple2 ), onArray$$anonfun$1(io.circe.Json )}, serializedLambda);
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Converter$.class);
    }

    public Option<Json> apply(Expr expr) {
        CirceHandler handler = new CirceHandler();
        Boolean wasConverted = (Boolean)expr.accept((Visitor)new JsonConverter((JsonHandler)handler, false));
        return Predef$.MODULE$.Boolean2boolean(wasConverted) ? Some$.MODULE$.apply((Object)handler.result()) : None$.MODULE$;
    }

    public Expr apply(Json json) {
        return (Expr)json.foldWith(folder);
    }
}

