/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

public enum Operator {
    OR("||", true),
    AND("&&", true),
    EQUALS("==", true),
    NOT_EQUALS("!=", true),
    PLUS("+", false),
    TIMES("*", false),
    TEXT_APPEND("++", false),
    LIST_APPEND("#", false),
    COMBINE("\u2227", false),
    PREFER("\u2afd", false),
    COMBINE_TYPES("\u2a53", false),
    IMPORT_ALT("?", false),
    EQUIVALENT("\u2261", false),
    COMPLETE("::", false);

    private static final Operator[] values;
    private final String value;
    private final boolean isBoolOperator;

    private Operator(String string2, boolean bl) {
        this.value = string2;
        this.isBoolOperator = bl;
    }

    public final boolean isBoolOperator() {
        return this.isBoolOperator;
    }

    public final int getLabel() {
        return this.ordinal();
    }

    public final String toString() {
        return this.value;
    }

    public static final Operator fromLabel(int n) {
        if (n >= 0 && n < values.length) {
            return values[n];
        }
        return null;
    }

    public static final Operator parse(String string) {
        if (string.equals(Operator.OR.value)) {
            return OR;
        }
        if (string.equals(Operator.AND.value)) {
            return AND;
        }
        if (string.equals(Operator.EQUALS.value)) {
            return EQUALS;
        }
        if (string.equals(Operator.NOT_EQUALS.value)) {
            return NOT_EQUALS;
        }
        if (string.equals(Operator.PLUS.value)) {
            return PLUS;
        }
        if (string.equals(Operator.TIMES.value)) {
            return TIMES;
        }
        if (string.equals(Operator.TEXT_APPEND.value)) {
            return TEXT_APPEND;
        }
        if (string.equals(Operator.LIST_APPEND.value)) {
            return LIST_APPEND;
        }
        if (string.equals(Operator.COMBINE.value) || string.equals("/\\")) {
            return COMBINE;
        }
        if (string.equals(Operator.PREFER.value) || string.equals("//")) {
            return PREFER;
        }
        if (string.equals(Operator.COMBINE_TYPES.value) || string.equals("//\\\\")) {
            return COMBINE_TYPES;
        }
        if (string.equals(Operator.IMPORT_ALT.value)) {
            return IMPORT_ALT;
        }
        if (string.equals(Operator.EQUIVALENT.value) || string.equals("===")) {
            return EQUIVALENT;
        }
        if (string.equals(Operator.COMPLETE.value)) {
            return COMPLETE;
        }
        throw new IllegalArgumentException(String.format("No org.dhallj.core.Operator represented by %s", string));
    }

    static {
        values = Operator.values();
    }
}

