/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.binary;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import org.dhallj.cbor.Reader;
import org.dhallj.cbor.Visitor;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.binary.DecodingException;

final class CBORDecodingVisitor
implements Visitor<Expr> {
    private final Reader reader;

    CBORDecodingVisitor(Reader reader) {
        this.reader = reader;
    }

    @Override
    public Expr onUnsignedInteger(BigInteger bigInteger) {
        return Expr.makeIdentifier("_", bigInteger.longValue());
    }

    @Override
    public Expr onNegativeInteger(BigInteger bigInteger) {
        return this.notExpected("Negative integer " + bigInteger);
    }

    @Override
    public Expr onByteString(byte[] byArray) {
        return this.notExpected("ByteString");
    }

    @Override
    public Expr onTextString(String string) {
        return Expr.makeBuiltIn(string);
    }

    @Override
    public Expr onVariableArray(BigInteger bigInteger, String string) {
        if (bigInteger.intValue() != 2) {
            throw new DecodingException("Variables must be encoded in an array of length 2");
        }
        if (string.equals("_")) {
            throw new DecodingException("Variables cannot be explicitly named _");
        }
        BigInteger bigInteger2 = this.reader.readPositiveBigNum();
        return Expr.makeIdentifier(string, bigInteger2.longValue());
    }

    @Override
    public Expr onArray(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = bigInteger2.intValue();
        switch (n) {
            case 0: {
                return this.readFnApplication(bigInteger);
            }
            case 1: {
                return this.readFunction(bigInteger);
            }
            case 2: {
                return this.readPi(bigInteger);
            }
            case 3: {
                return this.readOperator(bigInteger);
            }
            case 4: {
                return this.readList(bigInteger);
            }
            case 5: {
                return this.readSome(bigInteger);
            }
            case 6: {
                return this.readMerge(bigInteger);
            }
            case 7: {
                return this.readRecordType(bigInteger);
            }
            case 8: {
                return this.readRecordLiteral(bigInteger);
            }
            case 9: {
                return this.readFieldAccess(bigInteger);
            }
            case 10: {
                return this.readProjection(bigInteger);
            }
            case 11: {
                return this.readUnion(bigInteger);
            }
            case 14: {
                return this.readIf(bigInteger);
            }
            case 15: {
                return this.readNatural(bigInteger);
            }
            case 16: {
                return this.readInteger(bigInteger);
            }
            case 18: {
                return this.readTextLiteral(bigInteger);
            }
            case 19: {
                return this.readAssert(bigInteger);
            }
            case 24: {
                return this.readImport(bigInteger);
            }
            case 25: {
                return this.readLet(bigInteger);
            }
            case 26: {
                return this.readTypeAnnotation(bigInteger);
            }
            case 27: {
                return this.readMap(bigInteger);
            }
            case 28: {
                return this.readEmptyListAbstractType(bigInteger);
            }
        }
        throw new DecodingException(String.format("Array tag %d undefined", n));
    }

    @Override
    public Expr onMap(BigInteger bigInteger) {
        return this.notExpected("Map");
    }

    @Override
    public Expr onFalse() {
        return Expr.Constants.FALSE;
    }

    @Override
    public Expr onTrue() {
        return Expr.Constants.TRUE;
    }

    @Override
    public Expr onNull() {
        return null;
    }

    @Override
    public Expr onHalfFloat(float f) {
        return Expr.makeDoubleLiteral(f);
    }

    @Override
    public Expr onSingleFloat(float f) {
        return Expr.makeDoubleLiteral(f);
    }

    @Override
    public Expr onDoubleFloat(double d) {
        return Expr.makeDoubleLiteral(d);
    }

    @Override
    public Expr onTag() {
        return this.notExpected("Tag");
    }

    private Expr readFnApplication(BigInteger bigInteger) {
        if (bigInteger.longValue() < 3L) {
            throw new DecodingException("Function application must have at least one argument");
        }
        Expr expr = this.readExpr();
        ArrayList<Expr> arrayList = new ArrayList<Expr>();
        int n = 0;
        while ((long)n < bigInteger.longValue() - 2L) {
            Expr expr2 = this.readExpr();
            arrayList.add(expr2);
            ++n;
        }
        return Expr.makeApplication(expr, arrayList);
    }

    private Expr readFunction(BigInteger bigInteger) {
        long l = bigInteger.longValue();
        if (l == 3L) {
            Expr expr = this.readExpr();
            Expr expr2 = this.readExpr();
            return Expr.makeLambda("_", expr, expr2);
        }
        if (l == 4L) {
            String string = this.reader.readNullableTextString();
            if (string.equals("_")) {
                throw new DecodingException("Illegal explicit bound variable '_' in function");
            }
            Expr expr = this.readExpr();
            Expr expr3 = this.readExpr();
            return Expr.makeLambda(string, expr, expr3);
        }
        throw new DecodingException("Function types must be encoded in an array of length 3 or 4");
    }

    private Expr readPi(BigInteger bigInteger) {
        long l = bigInteger.longValue();
        if (l == 3L) {
            Expr expr = this.readExpr();
            Expr expr2 = this.readExpr();
            return Expr.makePi(expr, expr2);
        }
        if (l == 4L) {
            String string = this.reader.readNullableTextString();
            if (string.equals("_")) {
                throw new DecodingException("Illegal explicit bound variable '_' in pi type");
            }
            Expr expr = this.readExpr();
            Expr expr3 = this.readExpr();
            return Expr.makePi(string, expr, expr3);
        }
        throw new DecodingException("Pi types must be encoded in an array of length 3 or 4");
    }

    private Expr readOperator(BigInteger bigInteger) {
        if (bigInteger.longValue() != 4L) {
            throw new DecodingException("Operator application must be encoded in an array of length 4");
        }
        int n = this.reader.readUnsignedInteger().intValue();
        Expr expr = this.readExpr();
        Expr expr2 = this.readExpr();
        Operator operator = Operator.fromLabel(n);
        if (operator != null) {
            return Expr.makeOperatorApplication(operator, expr, expr2);
        }
        throw new DecodingException(String.format("Operator tag %d is undefined", n));
    }

    private Expr readList(BigInteger bigInteger) {
        Expr expr = this.readExpr();
        if (bigInteger.intValue() == 2) {
            if (expr == null) {
                throw new DecodingException("Type must be specified if list is empty");
            }
            return Expr.makeEmptyListLiteral(Expr.makeApplication(Expr.Constants.LIST, expr));
        }
        if (expr == null) {
            ArrayList<Expr> arrayList = new ArrayList<Expr>();
            int n = 2;
            while ((long)n < bigInteger.longValue()) {
                arrayList.add(this.readExpr());
                ++n;
            }
            return Expr.makeNonEmptyListLiteral(arrayList);
        }
        throw new DecodingException("Non-empty lists must not have a type annotation");
    }

    private Expr readEmptyListAbstractType(BigInteger bigInteger) {
        Expr expr = this.readExpr();
        if (bigInteger.intValue() == 2) {
            if (expr == null) {
                throw new DecodingException("Type must be specified if list is empty");
            }
            return Expr.makeEmptyListLiteral(expr);
        }
        throw new DecodingException(String.format("List of abstract type %s must be empty", new Object[0]));
    }

    private Expr readSome(BigInteger bigInteger) {
        int n = bigInteger.intValue();
        if (n != 3) {
            throw new DecodingException("Some must be encoded in an array of length 3");
        }
        this.readExpr();
        Expr expr = this.readExpr();
        return Expr.makeApplication(Expr.Constants.SOME, expr);
    }

    private Expr readMerge(BigInteger bigInteger) {
        int n = bigInteger.intValue();
        if (n == 3) {
            Expr expr = this.readExpr();
            Expr expr2 = this.readExpr();
            return Expr.makeMerge(expr, expr2);
        }
        if (n == 4) {
            Expr expr = this.readExpr();
            Expr expr3 = this.readExpr();
            Expr expr4 = this.readExpr();
            return Expr.makeMerge(expr, expr3, expr4);
        }
        throw new DecodingException("Merge must be encoded in an array of length 3 or 4");
    }

    private Expr readMap(BigInteger bigInteger) {
        int n = bigInteger.intValue();
        if (n == 2) {
            Expr expr = this.readExpr();
            return Expr.makeToMap(expr);
        }
        if (n == 3) {
            Expr expr = this.readExpr();
            Expr expr2 = this.readExpr();
            return Expr.makeToMap(expr, expr2);
        }
        throw new DecodingException("ToMap must be encoded in an array of length 2 or 3");
    }

    private Expr readRecordType(BigInteger bigInteger) {
        long l = bigInteger.longValue();
        if (l != 2L) {
            throw new DecodingException("Record literal must be encoded in an array of length 2");
        }
        Map<String, Expr> map = this.reader.readMap(this);
        return Expr.makeRecordType(map.entrySet());
    }

    private Expr readRecordLiteral(BigInteger bigInteger) {
        long l = bigInteger.longValue();
        if (l != 2L) {
            throw new DecodingException("Record literal must be encoded in an array of length 2");
        }
        Map<String, Expr> map = this.reader.readMap(this);
        return Expr.makeRecordLiteral(map.entrySet());
    }

    private Expr readFieldAccess(BigInteger bigInteger) {
        int n = bigInteger.intValue();
        if (n != 3) {
            throw new DecodingException("Field access must be encoded in array of length 3");
        }
        Expr expr = this.readExpr();
        String string = this.reader.readNullableTextString();
        return Expr.makeFieldAccess(expr, string);
    }

    private Expr readProjection(BigInteger bigInteger) {
        long l = bigInteger.longValue();
        Expr expr = this.readExpr();
        if (l == 2L) {
            return Expr.makeProjection(expr, new String[0]);
        }
        String string = this.reader.tryReadTextString();
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            int n = 3;
            while ((long)n < l) {
                arrayList.add(this.reader.tryReadTextString());
                ++n;
            }
            return Expr.makeProjection(expr, arrayList.toArray(new String[arrayList.size()]));
        }
        int n = this.reader.readArrayStart().intValue();
        if (n != 1) {
            throw new DecodingException("Type for type  projection must be encoded in an array of length 1");
        }
        Expr expr2 = this.readExpr();
        return Expr.makeProjectionByType(expr, expr2);
    }

    private Expr readUnion(BigInteger bigInteger) {
        int n = bigInteger.intValue();
        if (n != 2) {
            throw new DecodingException("Union must be encoded in array of length 2");
        }
        Map<String, Expr> map = this.reader.readMap(this);
        return Expr.makeUnionType(map.entrySet());
    }

    private Expr readIf(BigInteger bigInteger) {
        int n = bigInteger.intValue();
        if (n != 4) {
            throw new DecodingException("If must be encoded in an array of length 4");
        }
        Expr expr = this.readExpr();
        Expr expr2 = this.readExpr();
        Expr expr3 = this.readExpr();
        return Expr.makeIf(expr, expr2, expr3);
    }

    private Expr readTypeAnnotation(BigInteger bigInteger) {
        int n = bigInteger.intValue();
        if (n != 3) {
            throw new DecodingException("Type annotation must be encoded in array of length 3");
        }
        Expr expr = this.readExpr();
        Expr expr2 = this.readExpr();
        return Expr.makeAnnotated(expr, expr2);
    }

    private Expr readLet(BigInteger bigInteger) {
        return this.readLet(bigInteger.longValue());
    }

    private Expr readLet(long l) {
        if (l == 5L) {
            String string = this.reader.readNullableTextString();
            Expr expr = this.readExpr();
            Expr expr2 = this.readExpr();
            Expr expr3 = this.readExpr();
            return Expr.makeLet(string, expr, expr2, expr3);
        }
        String string = this.reader.readNullableTextString();
        Expr expr = this.readExpr();
        Expr expr4 = this.readExpr();
        return Expr.makeLet(string, expr, expr4, this.readLet(l - 3L));
    }

    private Expr readImport(BigInteger bigInteger) {
        byte[] byArray = this.reader.readNullableByteString();
        Expr.ImportMode importMode = this.readMode();
        int n = this.reader.readUnsignedInteger().intValue();
        switch (n) {
            case 0: {
                Expr expr = this.readExpr();
                return this.readRemoteImport(bigInteger, importMode, byArray, "http:/", expr);
            }
            case 1: {
                Expr expr = this.readExpr();
                return this.readRemoteImport(bigInteger, importMode, byArray, "https:/", expr);
            }
            case 2: {
                return this.readLocalImport(bigInteger, importMode, byArray, "/");
            }
            case 3: {
                return this.readLocalImport(bigInteger, importMode, byArray, "./");
            }
            case 4: {
                return this.readLocalImport(bigInteger, importMode, byArray, "../");
            }
            case 5: {
                return this.readLocalImport(bigInteger, importMode, byArray, "~");
            }
            case 6: {
                return this.readEnvImport(bigInteger, importMode, byArray);
            }
            case 7: {
                return Expr.makeMissingImport(importMode, byArray);
            }
        }
        throw new DecodingException(String.format("Import type %d is undefined", n));
    }

    private Expr.ImportMode readMode() {
        int n = this.reader.readUnsignedInteger().intValue();
        if (n == 0) {
            return Expr.ImportMode.CODE;
        }
        if (n == 1) {
            return Expr.ImportMode.RAW_TEXT;
        }
        if (n == 2) {
            return Expr.ImportMode.LOCATION;
        }
        throw new DecodingException(String.format("Import mode %d is undefined", n));
    }

    private Expr readLocalImport(BigInteger bigInteger, Expr.ImportMode importMode, byte[] byArray, String string) {
        Path path = Paths.get(string, new String[0]);
        int n = bigInteger.intValue();
        for (int i = 4; i < n; ++i) {
            path = path.resolve(this.reader.readNullableTextString());
        }
        return Expr.makeLocalImport(path, importMode, byArray);
    }

    private Expr readRemoteImport(BigInteger bigInteger, Expr.ImportMode importMode, byte[] byArray, String string, Expr expr) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = bigInteger.intValue();
        for (int i = 5; i < n - 1; ++i) {
            stringBuilder.append("/");
            stringBuilder.append(this.reader.readNullableTextString());
        }
        String string2 = this.reader.readNullableTextString();
        if (string2 != null) {
            stringBuilder.append("?");
            stringBuilder.append(string2);
        }
        try {
            return Expr.makeRemoteImport(new URI(stringBuilder.toString()), expr, importMode, byArray);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DecodingException("Invalid URL in remote import", uRISyntaxException);
        }
    }

    private Expr readEnvImport(BigInteger bigInteger, Expr.ImportMode importMode, byte[] byArray) {
        String string = this.reader.readNullableTextString();
        return Expr.makeEnvImport(string, importMode, byArray);
    }

    private Expr readAssert(BigInteger bigInteger) {
        long l = bigInteger.longValue();
        if (l != 2L) {
            throw new DecodingException("Assert must be encoded in array of length 2");
        }
        Expr expr = this.readExpr();
        return Expr.makeAssert(expr);
    }

    private Expr readTextLiteral(BigInteger bigInteger) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Expr> arrayList2 = new ArrayList<Expr>();
        String string = this.reader.readNullableTextString();
        arrayList.add(string);
        int n = 2;
        while ((long)n < bigInteger.longValue()) {
            Expr expr = this.readExpr();
            arrayList2.add(expr);
            string = this.reader.readNullableTextString();
            arrayList.add(string);
            n += 2;
        }
        return Expr.makeTextLiteral(arrayList.toArray(new String[0]), arrayList2.toArray(new Expr[0]));
    }

    private Expr readInteger(BigInteger bigInteger) {
        return Expr.makeIntegerLiteral(this.reader.readBigNum());
    }

    private Expr readNatural(BigInteger bigInteger) {
        return Expr.makeNaturalLiteral(this.reader.readPositiveBigNum());
    }

    private Expr readExpr() {
        return this.reader.nextSymbol(this);
    }

    private Expr notExpected(String string) {
        throw new DecodingException("Expected String or UnsignedInteger as first element of array. Found " + string);
    }
}

