/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.normalization;

import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.Source;
import org.dhallj.core.Visitor;
import org.dhallj.core.normalization.BetaNormalizeApplication;
import org.dhallj.core.normalization.BetaNormalizeFieldAccess;
import org.dhallj.core.normalization.BetaNormalizeIf;
import org.dhallj.core.normalization.BetaNormalizeMerge;
import org.dhallj.core.normalization.BetaNormalizeOperatorApplication;
import org.dhallj.core.normalization.BetaNormalizeProjection;
import org.dhallj.core.normalization.BetaNormalizeTextLiteral;
import org.dhallj.core.normalization.BetaNormalizeToMap;
import org.dhallj.core.normalization.NormalizationUtilities;

public final class BetaNormalize
extends Visitor.NoPrepareEvents<Expr> {
    public static final Visitor<Expr> instance = new BetaNormalize();

    @Override
    public void bind(String string, Expr expr) {
    }

    @Override
    public Expr onNote(Expr expr, Source source) {
        return expr;
    }

    @Override
    public Expr onNatural(Expr expr, BigInteger bigInteger) {
        return expr;
    }

    @Override
    public Expr onInteger(Expr expr, BigInteger bigInteger) {
        return expr;
    }

    @Override
    public Expr onDouble(Expr expr, double d) {
        return expr;
    }

    @Override
    public Expr onBuiltIn(Expr expr, String string) {
        return expr;
    }

    @Override
    public Expr onIdentifier(Expr expr, String string, long l) {
        return expr;
    }

    @Override
    public Expr onLambda(String string, Expr expr, Expr expr2) {
        return Expr.makeLambda(string, expr, expr2);
    }

    @Override
    public Expr onPi(String string, Expr expr, Expr expr2) {
        return Expr.makePi(string, expr, expr2);
    }

    @Override
    public Expr onLet(List<Expr.LetBinding<Expr>> list, Expr expr) {
        Expr expr2 = expr;
        for (int i = list.size() - 1; i >= 0; --i) {
            Expr.LetBinding<Expr> letBinding = list.get(i);
            String string = letBinding.getName();
            expr2 = expr2.substitute(string, letBinding.getValue());
        }
        return expr2.accept(this);
    }

    @Override
    public Expr onText(String[] stringArray, List<Expr> list) {
        return BetaNormalizeTextLiteral.apply(stringArray, list);
    }

    @Override
    public Expr onNonEmptyList(List<Expr> list) {
        return Expr.makeNonEmptyListLiteral(list);
    }

    @Override
    public Expr onEmptyList(Expr expr) {
        return Expr.makeEmptyListLiteral(expr);
    }

    @Override
    public Expr onRecord(List<Map.Entry<String, Expr>> list) {
        Collections.sort(list, NormalizationUtilities.entryComparator);
        return Expr.makeRecordLiteral(list);
    }

    @Override
    public Expr onRecordType(List<Map.Entry<String, Expr>> list) {
        Collections.sort(list, NormalizationUtilities.entryComparator);
        return Expr.makeRecordType(list);
    }

    @Override
    public Expr onUnionType(List<Map.Entry<String, Expr>> list) {
        Collections.sort(list, NormalizationUtilities.entryComparator);
        return Expr.makeUnionType(list);
    }

    @Override
    public Expr onFieldAccess(Expr expr, String string) {
        return BetaNormalizeFieldAccess.apply(expr, string);
    }

    @Override
    public Expr onProjection(Expr expr, String[] stringArray) {
        return BetaNormalizeProjection.apply(expr, stringArray);
    }

    @Override
    public Expr onProjectionByType(Expr expr, Expr expr2) {
        List<Map.Entry<String, Expr>> list = Expr.Util.asRecordType(expr2);
        TreeSet treeSet = new TreeSet();
        for (Map.Entry entry : list) {
            treeSet.add(entry.getKey());
        }
        return Expr.makeProjection(expr, treeSet.toArray(new String[treeSet.size()])).accept(this);
    }

    @Override
    public Expr onApplication(Expr expr, List<Expr> list) {
        return BetaNormalizeApplication.apply(expr, list);
    }

    @Override
    public Expr onOperatorApplication(Operator operator, Expr expr, Expr expr2) {
        return BetaNormalizeOperatorApplication.apply(operator, expr, expr2);
    }

    @Override
    public Expr onIf(Expr expr, Expr expr2, Expr expr3) {
        return BetaNormalizeIf.apply(expr, expr2, expr3);
    }

    @Override
    public Expr onAnnotated(Expr expr, Expr expr2) {
        return expr;
    }

    @Override
    public Expr onAssert(Expr expr) {
        return Expr.makeAssert(expr);
    }

    @Override
    public Expr onMerge(Expr expr, Expr expr2, Expr expr3) {
        return BetaNormalizeMerge.apply(expr, expr2, expr3);
    }

    @Override
    public Expr onToMap(Expr expr, Expr expr2) {
        return BetaNormalizeToMap.apply(expr, expr2);
    }

    @Override
    public Expr onMissingImport(Expr.ImportMode importMode, byte[] byArray) {
        return Expr.makeMissingImport(importMode, byArray);
    }

    @Override
    public Expr onEnvImport(String string, Expr.ImportMode importMode, byte[] byArray) {
        return Expr.makeEnvImport(string, importMode, byArray);
    }

    @Override
    public Expr onLocalImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
        return Expr.makeLocalImport(path, importMode, byArray);
    }

    @Override
    public Expr onRemoteImport(URI uRI, Expr expr, Expr.ImportMode importMode, byte[] byArray) {
        return Expr.makeRemoteImport(uRI, expr, importMode, byArray);
    }
}

