/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.normalization;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dhallj.core.Expr;

final class BetaNormalizeToMap {
    BetaNormalizeToMap() {
    }

    static final Expr apply(Expr expr, Expr expr2) {
        List<Map.Entry<String, Expr>> list = Expr.Util.asRecordLiteral(expr);
        if (list != null) {
            ArrayList<Expr> arrayList = new ArrayList<Expr>();
            for (Map.Entry entry : list) {
                arrayList.add(BetaNormalizeToMap.makeRecord((String)entry.getKey(), (Expr)entry.getValue()));
            }
            if (arrayList.isEmpty()) {
                return Expr.makeEmptyListLiteral(expr2);
            }
            return Expr.makeNonEmptyListLiteral(arrayList);
        }
        return Expr.makeToMap(expr, expr2);
    }

    private static final String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                char c2;
                if ((c2 = string.charAt(++i)) == '\\') {
                    stringBuilder.append("\\\\");
                    continue;
                }
                if (c2 == 'n') {
                    stringBuilder.append("\\\\n");
                    continue;
                }
                if (c2 == '$') {
                    stringBuilder.append("\\\\\\$");
                    continue;
                }
                stringBuilder.append("\\\\");
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static final Expr makeRecord(String string, Expr expr) {
        ArrayList<Map.Entry<String, Expr>> arrayList = new ArrayList<Map.Entry<String, Expr>>(2);
        arrayList.add(new AbstractMap.SimpleImmutableEntry<String, Expr>("mapKey", Expr.makeTextLiteral(BetaNormalizeToMap.escape(string))));
        arrayList.add(new AbstractMap.SimpleImmutableEntry<String, Expr>("mapValue", expr));
        return Expr.makeRecordLiteral(arrayList);
    }
}

