/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.typechecking;

import org.dhallj.core.DhallException;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;

public final class TypeCheckFailure
extends DhallException {
    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    TypeCheckFailure(String string) {
        super(string);
    }

    static TypeCheckFailure makeSortError() {
        return new TypeCheckFailure("Sort has no type, kind, or sort");
    }

    static TypeCheckFailure makeUnboundVariableError(String string) {
        return new TypeCheckFailure(String.format("Unbound variable: %s", string));
    }

    static TypeCheckFailure makeOperatorError(Operator operator) {
        switch (operator) {
            case OR: 
            case AND: 
            case EQUALS: 
            case NOT_EQUALS: {
                return new TypeCheckFailure(String.format("%s only works on Bools", new Object[]{operator}));
            }
            case PLUS: 
            case TIMES: {
                return new TypeCheckFailure(String.format("%s only works on Naturals", new Object[]{operator}));
            }
            case TEXT_APPEND: {
                return new TypeCheckFailure(String.format("%s only works on Text", new Object[]{operator}));
            }
            case LIST_APPEND: {
                return new TypeCheckFailure(String.format("%s only works on Lists", new Object[]{operator}));
            }
            case COMBINE: 
            case PREFER: {
                return new TypeCheckFailure("You can only combine records");
            }
            case COMBINE_TYPES: {
                return new TypeCheckFailure(String.format("%s requires arguments that are record types", new Object[]{operator}));
            }
            case EQUIVALENT: {
                return new TypeCheckFailure("Incomparable expression");
            }
        }
        return new TypeCheckFailure(String.format("Operator error on %s", new Object[]{operator}));
    }

    static TypeCheckFailure makeListAppendError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("You can only append Lists with matching element types");
    }

    static TypeCheckFailure makeEquivalenceError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("You can only append Lists with matching element types");
    }

    static TypeCheckFailure makeInterpolationError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("You can only interpolate Text");
    }

    static TypeCheckFailure makeSomeApplicationError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Some argument has the wrong type");
    }

    static TypeCheckFailure makeBuiltInApplicationError(String string, Expr expr, Expr expr2) {
        return new TypeCheckFailure(String.format("Can't apply %s", string));
    }

    static TypeCheckFailure makeApplicationTypeError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Wrong type of function argument");
    }

    static TypeCheckFailure makeApplicationError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Not a function");
    }

    static TypeCheckFailure makeUnresolvedImportError() {
        return new TypeCheckFailure("Can't type-check unresolved import");
    }

    static TypeCheckFailure makeIfPredicateError(Expr expr) {
        return new TypeCheckFailure("Invalid predicate for if");
    }

    static TypeCheckFailure makeIfBranchTypeMismatchError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("if branches must have matching types");
    }

    static TypeCheckFailure makeIfBranchError(Expr expr) {
        return new TypeCheckFailure("if branch is not a term");
    }

    static TypeCheckFailure makeLambdaInputError(Expr expr) {
        return new TypeCheckFailure("Invalid function input");
    }

    static TypeCheckFailure makeAssertError(Expr expr) {
        return new TypeCheckFailure("Not an equivalence");
    }

    static TypeCheckFailure makeFieldAccessError() {
        return new TypeCheckFailure("Not a record or union");
    }

    static TypeCheckFailure makeFieldAccessRecordMissingError(String string) {
        return new TypeCheckFailure(String.format("Missing record field: %s", string));
    }

    static TypeCheckFailure makeFieldAccessUnionMissingError(String string) {
        return new TypeCheckFailure(String.format("Missing constructor: %s", string));
    }

    static TypeCheckFailure makeProjectionError() {
        return new TypeCheckFailure("Not a record");
    }

    static TypeCheckFailure makeFieldTypeError(String string) {
        return new TypeCheckFailure("Invalid field type");
    }

    static TypeCheckFailure makeFieldDuplicateError(String string) {
        return new TypeCheckFailure(String.format("duplicate field: %s", string));
    }

    static TypeCheckFailure makeListTypeMismatchError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("List elements should all have the same type");
    }

    static TypeCheckFailure makeListTypeError(Expr expr) {
        return new TypeCheckFailure("Invalid type for List");
    }

    static TypeCheckFailure makeAnnotationError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Expression doesn't match annotation");
    }

    static TypeCheckFailure makeAlternativeTypeMismatchError(Expr expr) {
        return new TypeCheckFailure("Alternative annotation mismatch");
    }

    static TypeCheckFailure makeAlternativeTypeError(Expr expr) {
        return new TypeCheckFailure("Invalid alternative type");
    }

    static TypeCheckFailure makeAlternativeDuplicateError(String string) {
        return new TypeCheckFailure(String.format("duplicate field: %s", string));
    }

    static TypeCheckFailure makeMergeHandlersTypeError(Expr expr) {
        return new TypeCheckFailure("merge expects a record of handlers");
    }

    static TypeCheckFailure makeMergeUnionTypeError(Expr expr) {
        return new TypeCheckFailure("toMap expects a union or an Optional");
    }

    static TypeCheckFailure makeMergeHandlerMissingError(String string) {
        return new TypeCheckFailure(String.format("Missing handler: %s", string));
    }

    static TypeCheckFailure makeMergeHandlerUnusedError(String string) {
        return new TypeCheckFailure(String.format("Unused handler: %s", string));
    }

    static TypeCheckFailure makeMergeHandlerTypeInvalidError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Wrong handler input type");
    }

    static TypeCheckFailure makeMergeHandlerTypeNotFunctionError(String string, Expr expr, Expr expr2) {
        return new TypeCheckFailure(String.format("Handler for %s is not a function", string));
    }

    static TypeCheckFailure makeMergeHandlerTypeMismatchError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Handlers should have the same output type");
    }

    static TypeCheckFailure makeMergeHandlerTypeDisallowedError(Expr expr) {
        return new TypeCheckFailure("Disallowed handler type");
    }

    static TypeCheckFailure makeMergeInvalidAnnotationError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Expression doesn't match annotation");
    }

    static TypeCheckFailure makeToMapTypeError(Expr expr) {
        return new TypeCheckFailure("toMap expects a record value");
    }

    static TypeCheckFailure makeToMapRecordKindError(Expr expr) {
        return new TypeCheckFailure("toMap expects a record of kind Type");
    }

    static TypeCheckFailure makeToMapRecordTypeMismatchError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("toMap expects a homogenous record");
    }

    static TypeCheckFailure makeToMapResultTypeMismatchError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("toMap result type doesn't match annotation");
    }

    static TypeCheckFailure makeToMapMissingAnnotationError() {
        return new TypeCheckFailure("An empty toMap requires a type annotation");
    }

    static TypeCheckFailure makeToMapInvalidAnnotationError(Expr expr) {
        return new TypeCheckFailure("An empty toMap was annotated with an invalid type");
    }
}

