/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.cbor;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.dhallj.cbor.AdditionalInfo;
import org.dhallj.cbor.CBORException;
import org.dhallj.cbor.MajorType;
import org.dhallj.cbor.NullVisitor;
import org.dhallj.cbor.Visitor;

public abstract class Reader {
    public <R> R nextSymbol(Visitor<R> visitor) {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case UNSIGNED_INTEGER: {
                return visitor.onUnsignedInteger(this.readUnsignedInteger(by));
            }
            case NEGATIVE_INTEGER: {
                return visitor.onNegativeInteger(this.readNegativeInteger(by));
            }
            case BYTE_STRING: {
                return visitor.onByteString(this.readByteString(by));
            }
            case TEXT_STRING: {
                return visitor.onTextString(this.readTextString(by));
            }
            case ARRAY: {
                return this.readArrayStart(by, visitor);
            }
            case MAP: {
                return visitor.onMap(this.readMapStart(by));
            }
            case SEMANTIC_TAG: {
                throw new CBORException("We should have skipped semantic tags");
            }
            case PRIMITIVE: {
                return this.readPrimitive(by, visitor);
            }
        }
        throw new CBORException(String.format("Invalid CBOR major type %d", by));
    }

    protected abstract byte read();

    protected abstract byte peek();

    protected abstract byte[] read(int var1);

    public BigInteger readUnsignedInteger() {
        this.skip55799();
        return this.readUnsignedInteger(this.read());
    }

    public BigInteger readPositiveBigNum() {
        this.skip55799();
        BigInteger bigInteger = this.readBigNum();
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new CBORException(String.format("%s is not a positive big num", bigInteger));
        }
        return bigInteger;
    }

    public BigInteger readBigNum() {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case UNSIGNED_INTEGER: {
                return this.readUnsignedInteger(by);
            }
            case NEGATIVE_INTEGER: {
                return this.readNegativeInteger(by);
            }
            case SEMANTIC_TAG: {
                AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
                BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
                long l = bigInteger.longValue();
                BigInteger bigInteger2 = this.readUnsignedInteger();
                long l2 = bigInteger2.longValue();
                BigInteger bigInteger3 = this.readBigInteger(l2);
                if (l == 2L) {
                    return bigInteger3;
                }
                if (l == 3L) {
                    return BigInteger.valueOf(-1L).subtract(bigInteger3);
                }
                throw new CBORException(String.format("%d is not a valid tag for a bignum", l));
            }
        }
        throw new CBORException(String.format("%d not a valid major type for an Unsigned Integer", new Object[0]));
    }

    public String readNullableTextString() {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case TEXT_STRING: {
                return this.readTextString(by);
            }
            case PRIMITIVE: {
                return this.readPrimitive(by, NullVisitor.instanceForString);
            }
        }
        throw new CBORException("Next symbol is neither a text string or null");
    }

    public byte[] readNullableByteString() {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case BYTE_STRING: {
                return this.readByteString(by);
            }
            case PRIMITIVE: {
                return this.readPrimitive(by, NullVisitor.instanceForByteArray);
            }
        }
        throw new CBORException("Next symbol is neither a byte string or null");
    }

    public String tryReadTextString() {
        this.skip55799();
        byte by = this.peek();
        switch (MajorType.fromByte(by)) {
            case TEXT_STRING: {
                return this.readTextString(this.read());
            }
        }
        return null;
    }

    public BigInteger readArrayStart() {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case ARRAY: {
                AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
                BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
                if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
                    throw new CBORException("Indefinite array not needed for Dhall");
                }
                return bigInteger;
            }
        }
        throw new CBORException("Next symbol is not an array");
    }

    public <R> Map<String, R> readMap(Visitor<R> visitor) {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case MAP: {
                BigInteger bigInteger = this.readMapStart(by);
                HashMap<String, R> hashMap = new HashMap<String, R>();
                int n = 0;
                while ((long)n < bigInteger.longValue()) {
                    String string = this.readNullableTextString();
                    R r = this.nextSymbol(visitor);
                    hashMap.put(string, r);
                    ++n;
                }
                return hashMap;
            }
        }
        throw new CBORException(String.format("Cannot read map - major type is %s", new Object[]{MajorType.fromByte(by)}));
    }

    private BigInteger readUnsignedInteger(byte by) {
        AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
        return this.readBigInteger(additionalInfo, by);
    }

    private BigInteger readNegativeInteger(byte by) {
        AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
        return BigInteger.valueOf(-1L).subtract(this.readBigInteger(additionalInfo, by));
    }

    private byte[] readByteString(byte by) {
        AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
        BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new CBORException("Indefinite byte string not needed for Dhall");
        }
        return this.read(bigInteger.intValue());
    }

    private String readTextString(byte by) {
        AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
        BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new CBORException("Indefinite text string not needed for Dhall");
        }
        return new String(this.read(bigInteger.intValue()), Charset.forName("UTF-8"));
    }

    private <R> R readArrayStart(byte by, Visitor<R> visitor) {
        AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
        BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new CBORException("Indefinite array not needed for Dhall");
        }
        this.skip55799();
        byte by2 = this.read();
        switch (MajorType.fromByte(by2)) {
            case UNSIGNED_INTEGER: {
                return visitor.onArray(bigInteger, this.readUnsignedInteger(by2));
            }
            case TEXT_STRING: {
                return visitor.onVariableArray(bigInteger, this.readTextString(by2));
            }
        }
        throw new CBORException(String.format("Invalid start to CBOR-encoded Dhall expression %s", MajorType.fromByte(by).toString()));
    }

    private BigInteger readMapStart(byte by) {
        AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
        BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new CBORException("Indefinite array not needed for Dhall");
        }
        return bigInteger;
    }

    private <R> R readPrimitive(byte by, Visitor<R> visitor) {
        int n = by & 0x1F;
        if (0 <= n && n <= 19) {
            throw new CBORException(String.format("Primitive %d is unassigned", n));
        }
        if (n == 20) {
            return visitor.onFalse();
        }
        if (n == 21) {
            return visitor.onTrue();
        }
        if (n == 22) {
            return visitor.onNull();
        }
        if (n == 23) {
            throw new CBORException(String.format("Primitive %d is unassigned", n));
        }
        if (n == 24) {
            throw new CBORException("Simple value not needed for Dhall");
        }
        if (n == 25) {
            int n2;
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < 2; ++n3) {
                n2 = this.read() & 0xFF;
                n4 <<= 8;
                n4 |= n2;
            }
            n3 = (n4 & 0x8000) >> 15;
            n2 = (n4 & 0x7C00) >> 10;
            int n5 = n4 & 0x3FF;
            float f = 0.0f;
            f = n2 == 0 ? (float)((double)(n3 != 0 ? -1 : 1) * Math.pow(2.0, -14.0) * ((double)n5 / Math.pow(2.0, 10.0))) : (n2 == 31 ? (n5 != 0 ? Float.NaN : (float)(n3 != 0 ? -1 : 1) * Float.POSITIVE_INFINITY) : (float)((double)(n3 != 0 ? -1 : 1) * Math.pow(2.0, n2 - 15) * (1.0 + (double)n5 / Math.pow(2.0, 10.0))));
            return visitor.onHalfFloat(f);
        }
        if (n == 26) {
            int n6 = 0;
            for (int i = 0; i < 4; ++i) {
                int n7 = this.read() & 0xFF;
                n6 <<= 8;
                n6 |= n7;
            }
            return visitor.onSingleFloat(Float.intBitsToFloat(n6));
        }
        if (n == 27) {
            long l = 0L;
            for (int i = 0; i < 8; ++i) {
                int n8 = this.read() & 0xFF;
                l <<= 8;
                l |= (long)n8;
            }
            return visitor.onDoubleFloat(Double.longBitsToDouble(l));
        }
        if (28 <= n && n <= 30) {
            throw new CBORException(String.format("Primitive %d is unassigned", n));
        }
        if (n == 31) {
            throw new CBORException("Break stop code not needed for Dhall");
        }
        throw new CBORException(String.format("Primitive %d is not valid", n));
    }

    private void skip55799() {
        byte by = this.peek();
        switch (MajorType.fromByte(by)) {
            case SEMANTIC_TAG: {
                AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
                switch (additionalInfo) {
                    case DIRECT: {
                        return;
                    }
                }
                BigInteger bigInteger = this.readBigInteger(additionalInfo, this.read());
                int n = bigInteger.intValue();
                if (n != 55799) {
                    throw new CBORException(String.format("Unrecognized CBOR semantic tag %d", n));
                }
                this.skip55799();
            }
        }
    }

    private BigInteger readBigInteger(AdditionalInfo additionalInfo, byte by) {
        switch (additionalInfo) {
            case DIRECT: {
                return BigInteger.valueOf(by & 0x1F);
            }
            case ONE_BYTE: {
                return this.readBigInteger(1L);
            }
            case TWO_BYTES: {
                return this.readBigInteger(2L);
            }
            case FOUR_BYTES: {
                return this.readBigInteger(4L);
            }
            case EIGHT_BYTES: {
                return this.readBigInteger(8L);
            }
            case RESERVED: {
                throw new CBORException("Additional info RESERVED should not require reading a uintXX");
            }
            case INDEFINITE: {
                return BigInteger.valueOf(-1L);
            }
        }
        throw new IllegalArgumentException("Invalid AdditionalInfo");
    }

    private BigInteger readBigInteger(long l) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (long i = 0L; i < l; ++i) {
            int n = this.read() & 0xFF;
            bigInteger = bigInteger.shiftLeft(8).or(BigInteger.valueOf(n));
        }
        return bigInteger;
    }

    public static final class ByteArrayReader
    extends Reader {
        private final byte[] bytes;
        private int cursor = 0;

        public ByteArrayReader(byte[] byArray) {
            this.bytes = byArray;
        }

        @Override
        protected byte read() {
            return this.bytes[this.cursor++];
        }

        @Override
        protected byte peek() {
            return this.bytes[this.cursor];
        }

        @Override
        protected byte[] read(int n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.bytes, this.cursor, byArray, 0, n);
            this.cursor += n;
            return byArray;
        }
    }
}

