/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

import org.dhallj.core.Operator;

final class ToStringState {
    static final int BASE = 0;
    static final int APPLICATION = 1;
    static final int FIELD_ACCESS = 99;
    static final int ASSERT = 100;
    static final int MERGE = 102;
    static final int TO_MAP = 102;
    static final int APPLICATION_ARGUMENT = 102;
    static final int ANNOTATED = 104;
    static final int LAMBDA = 105;
    static final int PI = 105;
    static final int LET = 105;
    static final int IF = 106;
    static final int NONE = Integer.MAX_VALUE;
    private final String text;
    private final int looseness;
    private static final int baseOperatorLooseness = 4;

    ToStringState(String string, int n) {
        this.text = string;
        this.looseness = n;
    }

    ToStringState(String string) {
        this(string, 0);
    }

    ToStringState withText(String string) {
        return new ToStringState(string, this.looseness);
    }

    String toString(int n, boolean bl) {
        if (n > this.looseness || !bl && n == this.looseness) {
            return this.text;
        }
        return String.format("(%s)", this.text);
    }

    String toString(int n) {
        return this.toString(n, false);
    }

    public String toString() {
        return this.toString(Integer.MAX_VALUE);
    }

    static final int getOperatorLooseness(Operator operator) {
        int n = 4;
        switch (operator) {
            case COMPLETE: {
                ++n;
            }
            case IMPORT_ALT: {
                ++n;
            }
            case OR: {
                ++n;
            }
            case PLUS: {
                ++n;
            }
            case TEXT_APPEND: {
                ++n;
            }
            case LIST_APPEND: {
                ++n;
            }
            case AND: {
                ++n;
            }
            case COMBINE: {
                ++n;
            }
            case PREFER: {
                ++n;
            }
            case COMBINE_TYPES: {
                ++n;
            }
            case TIMES: {
                ++n;
            }
            case EQUALS: {
                ++n;
            }
            case NOT_EQUALS: {
                ++n;
            }
            case EQUIVALENT: {
                ++n;
            }
        }
        return n;
    }
}

