/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.Source;
import org.dhallj.core.ToStringState;
import org.dhallj.core.Visitor;

final class ToStringVisitor
extends Visitor.NoPrepareEvents<ToStringState> {
    public static Visitor<ToStringState> instance = new ToStringVisitor();

    ToStringVisitor() {
    }

    @Override
    public void bind(String string, Expr expr) {
    }

    @Override
    public ToStringState onNote(ToStringState toStringState, Source source) {
        return toStringState;
    }

    @Override
    public ToStringState onNatural(Expr expr, BigInteger bigInteger) {
        return new ToStringState(bigInteger.toString());
    }

    @Override
    public ToStringState onInteger(Expr expr, BigInteger bigInteger) {
        String string = bigInteger.compareTo(BigInteger.ZERO) >= 0 ? String.format("+%s", bigInteger.toString()) : bigInteger.toString();
        return new ToStringState(string);
    }

    @Override
    public ToStringState onDouble(Expr expr, double d) {
        return new ToStringState(Double.toString(d));
    }

    @Override
    public ToStringState onBuiltIn(Expr expr, String string) {
        return new ToStringState(string);
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isSimpleLabel(String string) {
        char c = string.charAt(0);
        if (!ToStringVisitor.isAlpha(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (ToStringVisitor.isAlpha(c) || ToStringVisitor.isDigit(c) || c == '-' || c == '/' || c == '_') continue;
            return false;
        }
        return true;
    }

    private static String escapeName(String string) {
        if (!ToStringVisitor.isSimpleLabel(string) || Expr.Constants.isBuiltIn(string) || Expr.Constants.isKeyword(string)) {
            return String.format("`%s`", string);
        }
        return string;
    }

    @Override
    public ToStringState onIdentifier(Expr expr, String string, long l) {
        String string2 = ToStringVisitor.escapeName(string);
        return new ToStringState(l == 0L ? string2 : String.format("%s@%d", string2, l));
    }

    @Override
    public ToStringState onLambda(String string, ToStringState toStringState, ToStringState toStringState2) {
        return new ToStringState(String.format("\u03bb(%s : %s) \u2192 %s", ToStringVisitor.escapeName(string), toStringState.toString(105, true), toStringState2.toString(105)), 105);
    }

    @Override
    public ToStringState onPi(String string, ToStringState toStringState, ToStringState toStringState2) {
        String string2 = toStringState.toString(105, true);
        String string3 = toStringState2.toString(105);
        return new ToStringState(string.equals("_") ? String.format("%s \u2192 %s", string2, string3) : String.format("\u2200(%s : %s) \u2192 %s", ToStringVisitor.escapeName(string), string2, string3), 105);
    }

    public ToStringState onLet(String string, ToStringState toStringState, ToStringState toStringState2, ToStringState toStringState3) {
        String string2 = toStringState == null ? "" : String.format(" : %s", toStringState.toString(105));
        return new ToStringState(String.format("let %s%s = %s in %s", ToStringVisitor.escapeName(string), string2, toStringState2.toString(105), toStringState3.toString(105)), 105);
    }

    @Override
    public ToStringState onLet(List<Expr.LetBinding<ToStringState>> list, ToStringState toStringState) {
        String string = toStringState.toString(105);
        for (int i = list.size() - 1; i >= 0; --i) {
            Expr.LetBinding<ToStringState> letBinding = list.get(i);
            String string2 = letBinding.hasType() ? String.format(" : %s", letBinding.getType().toString(105)) : "";
            string = String.format("let %s%s = %s in %s", ToStringVisitor.escapeName(letBinding.getName()), string2, letBinding.getValue().toString(105), string);
        }
        return new ToStringState(string, 105);
    }

    @Override
    public ToStringState onText(String[] stringArray, List<ToStringState> list) {
        StringBuilder stringBuilder = new StringBuilder("\"");
        stringBuilder.append(Expr.Util.escapeText(stringArray[0], false));
        int n = 1;
        Iterator<ToStringState> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("${");
            stringBuilder.append(iterator.next().toString(Integer.MAX_VALUE));
            stringBuilder.append("}");
            stringBuilder.append(Expr.Util.escapeText(stringArray[n++], false));
        }
        if (n < stringArray.length) {
            stringBuilder.append(Expr.Util.escapeText(stringArray[n], false));
        }
        stringBuilder.append("\"");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onNonEmptyList(List<ToStringState> list) {
        StringBuilder stringBuilder = new StringBuilder("[");
        Iterator<ToStringState> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString(Integer.MAX_VALUE));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onEmptyList(ToStringState toStringState) {
        return new ToStringState(String.format("[] : %s", toStringState), 104);
    }

    @Override
    public ToStringState onRecord(List<Map.Entry<String, ToStringState>> list) {
        if (list.isEmpty()) {
            return new ToStringState("{=}");
        }
        StringBuilder stringBuilder = new StringBuilder("{");
        Iterator<Map.Entry<String, ToStringState>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ToStringState> entry = iterator.next();
            stringBuilder.append(ToStringVisitor.escapeName(entry.getKey()));
            stringBuilder.append(" = ");
            stringBuilder.append(entry.getValue().toString(Integer.MAX_VALUE));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onRecordType(List<Map.Entry<String, ToStringState>> list) {
        StringBuilder stringBuilder = new StringBuilder("{");
        Iterator<Map.Entry<String, ToStringState>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ToStringState> entry = iterator.next();
            stringBuilder.append(ToStringVisitor.escapeName(entry.getKey()));
            stringBuilder.append(" : ");
            stringBuilder.append(entry.getValue().toString(Integer.MAX_VALUE));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onUnionType(List<Map.Entry<String, ToStringState>> list) {
        StringBuilder stringBuilder = new StringBuilder("<");
        Iterator<Map.Entry<String, ToStringState>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ToStringState> entry = iterator.next();
            stringBuilder.append(ToStringVisitor.escapeName(entry.getKey()));
            ToStringState toStringState = entry.getValue();
            if (toStringState != null) {
                stringBuilder.append(" : ");
                stringBuilder.append(toStringState.toString());
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" | ");
        }
        stringBuilder.append(">");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onFieldAccess(ToStringState toStringState, String string) {
        return new ToStringState(String.format("%s.%s", toStringState.toString(99), string), 99);
    }

    @Override
    public ToStringState onProjection(ToStringState toStringState, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(toStringState.toString(99));
        stringBuilder.append(".{");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return new ToStringState(stringBuilder.toString(), 99);
    }

    @Override
    public ToStringState onProjectionByType(ToStringState toStringState, ToStringState toStringState2) {
        return new ToStringState(String.format("%s.(%s)", toStringState.toString(99), toStringState2.toString(Integer.MAX_VALUE)), 99);
    }

    @Override
    public ToStringState onApplication(ToStringState toStringState, List<ToStringState> list) {
        StringBuilder stringBuilder = new StringBuilder(toStringState.toString(1));
        stringBuilder.append(" ");
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i).toString(1, true));
            if (i >= list.size() - 1) continue;
            stringBuilder.append(" ");
        }
        return new ToStringState(stringBuilder.toString(), 1);
    }

    @Override
    public ToStringState onOperatorApplication(Operator operator, ToStringState toStringState, ToStringState toStringState2) {
        int n = ToStringState.getOperatorLooseness(operator);
        return new ToStringState(String.format("%s %s %s", new Object[]{toStringState.toString(n), operator, toStringState2.toString(n, true)}), n);
    }

    @Override
    public ToStringState onIf(ToStringState toStringState, ToStringState toStringState2, ToStringState toStringState3) {
        return new ToStringState(String.format("if %s then %s else %s", toStringState.toString(106), toStringState2.toString(106), toStringState3.toString(106)), 106);
    }

    @Override
    public ToStringState onAnnotated(ToStringState toStringState, ToStringState toStringState2) {
        return new ToStringState(String.format("%s : %s", toStringState.toString(104), toStringState2.toString(104)), 104);
    }

    @Override
    public ToStringState onAssert(ToStringState toStringState) {
        return new ToStringState(String.format("assert : %s", toStringState.toString(100)), 100);
    }

    @Override
    public ToStringState onMerge(ToStringState toStringState, ToStringState toStringState2, ToStringState toStringState3) {
        StringBuilder stringBuilder = new StringBuilder("merge ");
        stringBuilder.append(toStringState.toString(102));
        stringBuilder.append(" ");
        stringBuilder.append(toStringState2.toString(0));
        if (toStringState3 != null) {
            stringBuilder.append(" : ");
            stringBuilder.append(toStringState3.toString(102));
        }
        return new ToStringState(stringBuilder.toString(), 102);
    }

    @Override
    public ToStringState onToMap(ToStringState toStringState, ToStringState toStringState2) {
        StringBuilder stringBuilder = new StringBuilder("toMap ");
        stringBuilder.append(toStringState.toString(102, true));
        if (toStringState2 != null) {
            stringBuilder.append(" : ");
            stringBuilder.append(toStringState2.toString(0));
        }
        return new ToStringState(stringBuilder.toString(), 102);
    }

    @Override
    public ToStringState onMissingImport(Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("missing");
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), 0);
    }

    @Override
    public ToStringState onEnvImport(String string, Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("env:");
        stringBuilder.append(string);
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), 0);
    }

    @Override
    public ToStringState onLocalImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(path.toString());
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), 0);
    }

    @Override
    public ToStringState onRemoteImport(URI uRI, ToStringState toStringState, Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(uRI.toString());
        if (toStringState != null) {
            stringBuilder.append(" using ");
            stringBuilder.append(toStringState.toString(0));
        }
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), 0);
    }
}

