/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.converters;

import java.io.PrintWriter;
import java.math.BigInteger;

public interface JsonHandler {
    public void onNull();

    public void onBoolean(boolean var1);

    public void onNumber(BigInteger var1);

    public void onDouble(double var1);

    public void onString(String var1);

    public void onArrayStart();

    public void onArrayEnd();

    public void onArrayElementGap();

    public void onObjectStart();

    public void onObjectEnd();

    public void onObjectField(String var1);

    public void onObjectFieldGap();

    public static final class CompactStringPrinter
    implements JsonHandler {
        private final StringBuilder builder = new StringBuilder();

        public String toString() {
            return this.builder.toString();
        }

        @Override
        public void onNull() {
            this.builder.append("null");
        }

        @Override
        public void onBoolean(boolean bl) {
            this.builder.append(bl);
        }

        @Override
        public void onNumber(BigInteger bigInteger) {
            this.builder.append(bigInteger.toString());
        }

        @Override
        public void onDouble(double d) {
            this.builder.append(d);
        }

        @Override
        public void onString(String string) {
            this.builder.append(String.format("\"%s\"", string));
        }

        @Override
        public void onArrayStart() {
            this.builder.append("[");
        }

        @Override
        public void onArrayEnd() {
            this.builder.append("]");
        }

        @Override
        public void onArrayElementGap() {
            this.builder.append(",");
        }

        @Override
        public void onObjectStart() {
            this.builder.append("{");
        }

        @Override
        public void onObjectEnd() {
            this.builder.append("}");
        }

        @Override
        public void onObjectField(String string) {
            this.builder.append(String.format("\"%s\":", string));
        }

        @Override
        public void onObjectFieldGap() {
            this.builder.append(",");
        }
    }

    public static final class CompactPrinter
    implements JsonHandler {
        private final PrintWriter writer;

        public CompactPrinter(PrintWriter printWriter) {
            this.writer = printWriter;
        }

        @Override
        public void onNull() {
            this.writer.print("null");
        }

        @Override
        public void onBoolean(boolean bl) {
            this.writer.print(bl);
        }

        @Override
        public void onNumber(BigInteger bigInteger) {
            this.writer.print(bigInteger.toString());
        }

        @Override
        public void onDouble(double d) {
            this.writer.print(d);
        }

        @Override
        public void onString(String string) {
            this.writer.printf("\"%s\"", string);
        }

        @Override
        public void onArrayStart() {
            this.writer.print("[");
        }

        @Override
        public void onArrayEnd() {
            this.writer.print("]");
        }

        @Override
        public void onArrayElementGap() {
            this.writer.print(",");
        }

        @Override
        public void onObjectStart() {
            this.writer.print("{");
        }

        @Override
        public void onObjectEnd() {
            this.writer.print("}");
        }

        @Override
        public void onObjectField(String string) {
            this.writer.printf("\"%s\":", string);
        }

        @Override
        public void onObjectFieldGap() {
            this.writer.print(",");
        }
    }
}

