/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.normalization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dhallj.core.Expr;
import org.dhallj.core.ExternalVisitor;
import org.dhallj.core.Operator;
import org.dhallj.core.normalization.BetaNormalize;

final class BetaNormalizeProjection {
    BetaNormalizeProjection() {
    }

    static final Expr apply(Expr expr, final String[] stringArray) {
        if (stringArray.length == 0) {
            return Expr.Constants.EMPTY_RECORD_LITERAL;
        }
        Expr expr2 = expr.accept(new ExternalVisitor.Constant<Expr>(null){

            @Override
            public Expr onRecord(Iterable<Map.Entry<String, Expr>> iterable, int n) {
                HashSet<String> hashSet = new HashSet<String>(stringArray.length);
                for (String string : stringArray) {
                    hashSet.add(string);
                }
                TreeMap treeMap = new TreeMap();
                for (Map.Entry<String, Expr> entry : iterable) {
                    if (!hashSet.contains(entry.getKey())) continue;
                    treeMap.put(entry.getKey(), entry.getValue());
                }
                return Expr.makeRecordLiteral(treeMap.entrySet());
            }

            @Override
            public Expr onProjection(Expr expr, String[] stringArray2) {
                return Expr.makeProjection(expr, stringArray).accept(BetaNormalize.instance);
            }

            @Override
            public Expr onOperatorApplication(Operator operator, Expr expr, Expr expr2) {
                List<Map.Entry<String, Expr>> list;
                if (operator.equals((Object)Operator.PREFER) && (list = Expr.Util.asRecordLiteral(expr2)) != null) {
                    HashSet hashSet = new HashSet();
                    TreeSet<String> treeSet = new TreeSet<String>();
                    TreeSet<String> treeSet2 = new TreeSet<String>();
                    for (Map.Entry entry : list) {
                        hashSet.add(entry.getKey());
                    }
                    for (String string : stringArray) {
                        if (hashSet.contains(string)) {
                            treeSet2.add(string);
                            continue;
                        }
                        treeSet.add(string);
                    }
                    return Expr.makeOperatorApplication(Operator.PREFER, Expr.makeProjection(expr, treeSet.toArray(new String[treeSet.size()])), Expr.makeProjection(expr2, treeSet2.toArray(new String[treeSet.size()]))).accept(BetaNormalize.instance);
                }
                return null;
            }
        });
        if (expr2 != null) {
            return expr2;
        }
        Object[] objectArray = new String[stringArray.length];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        Arrays.sort(objectArray);
        return Expr.makeProjection(expr, (String[])objectArray);
    }
}

