/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.normalization;

import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;

final class NormalizationUtilities {
    static final Expr[] prependValue = new Expr[]{Expr.makeIdentifier("a")};
    static final Expr prependExpr = Expr.makeOperatorApplication(Operator.LIST_APPEND, Expr.makeNonEmptyListLiteral(prependValue), Expr.makeIdentifier("as"));
    static final Comparator<Map.Entry<String, Expr>> entryComparator = new Comparator<Map.Entry<String, Expr>>(){

        @Override
        public int compare(Map.Entry<String, Expr> entry, Map.Entry<String, Expr> entry2) {
            return entry.getKey().compareTo(entry2.getKey());
        }
    };

    NormalizationUtilities() {
    }

    static final Expr booleanToExpr(boolean bl) {
        return bl ? Expr.Constants.TRUE : Expr.Constants.FALSE;
    }

    static final Expr indexedRecordType(Expr expr) {
        Map.Entry[] entryArray = new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<String, Expr>("index", Expr.Constants.NATURAL), new AbstractMap.SimpleImmutableEntry<String, Expr>("value", expr)};
        return Expr.makeRecordType(entryArray);
    }

    static final <A> A lookup(Iterable<Map.Entry<String, A>> iterable, String string) {
        for (Map.Entry<String, A> entry : iterable) {
            if (!entry.getKey().equals(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    static final <A> Map.Entry<String, A> lookupEntry(Iterable<Map.Entry<String, A>> iterable, String string) {
        for (Map.Entry<String, A> entry : iterable) {
            if (!entry.getKey().equals(string)) continue;
            return entry;
        }
        return null;
    }
}

