/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

import org.dhallj.core.Operator;

final class ToStringState {
    static final int NONE = 0;
    static final int OPERATOR = 1;
    static final int APPLICATION = Operator.NOT_EQUALS.getPrecedence() + 1;
    static final int IMPORT = APPLICATION + 1;
    static final int COMPLETE = IMPORT + 1;
    static final int SELECTOR = COMPLETE + 1;
    static final int PRIMITIVE = SELECTOR + 1;
    private final String text;
    private final int level;

    ToStringState(String string, int n) {
        this.text = string;
        this.level = n;
    }

    ToStringState(String string) {
        this(string, PRIMITIVE);
    }

    ToStringState withText(String string) {
        return new ToStringState(string, this.level);
    }

    String toString(int n) {
        if (this.level < n) {
            return "(" + this.text + ")";
        }
        return this.text;
    }

    public String toString() {
        return this.toString(0);
    }

    static final int getOperatorLevel(Operator operator) {
        if (operator == Operator.COMPLETE) {
            return COMPLETE;
        }
        return operator.getPrecedence();
    }
}

