/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.Source;
import org.dhallj.core.ToStringState;
import org.dhallj.core.Visitor;

final class ToStringVisitor
extends Visitor.NoPrepareEvents<ToStringState> {
    public static Visitor<ToStringState> instance = new ToStringVisitor();

    ToStringVisitor() {
    }

    @Override
    public void bind(String string, Expr expr) {
    }

    @Override
    public ToStringState onNote(ToStringState toStringState, Source source) {
        return toStringState;
    }

    @Override
    public ToStringState onNatural(Expr expr, BigInteger bigInteger) {
        return new ToStringState(bigInteger.toString());
    }

    @Override
    public ToStringState onInteger(Expr expr, BigInteger bigInteger) {
        String string = bigInteger.compareTo(BigInteger.ZERO) >= 0 ? "+" + bigInteger.toString() : bigInteger.toString();
        return new ToStringState(string);
    }

    @Override
    public ToStringState onDouble(Expr expr, double d) {
        return new ToStringState(Double.toString(d));
    }

    private static String pad2(int n) {
        String string = Integer.toString(n);
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    private static String pad4(int n) {
        String string = Integer.toString(n);
        for (int i = 0; i < string.length() - 4; ++i) {
            string = "0" + string;
        }
        return string;
    }

    @Override
    public ToStringState onDate(Expr expr, int n, int n2, int n3) {
        return new ToStringState(ToStringVisitor.pad4(n) + "-" + ToStringVisitor.pad2(n2) + "-" + ToStringVisitor.pad2(n3));
    }

    @Override
    public ToStringState onTime(Expr expr, int n, int n2, int n3, BigDecimal bigDecimal) {
        String string = ToStringVisitor.pad2(n) + ":" + ToStringVisitor.pad2(n2) + ":" + ToStringVisitor.pad2(n3);
        if (!bigDecimal.equals(BigDecimal.ZERO)) {
            string = string + bigDecimal.toString().substring(1);
        }
        return new ToStringState(string);
    }

    @Override
    public ToStringState onTimeZone(Expr expr, int n) {
        if (Long.signum(n) < 0) {
            return new ToStringState("-" + ToStringVisitor.pad2(-n / 60) + ToStringVisitor.pad2(-n % 60));
        }
        return new ToStringState("+" + ToStringVisitor.pad2(n / 60) + ToStringVisitor.pad2(n % 60));
    }

    @Override
    public ToStringState onBuiltIn(Expr expr, String string) {
        return new ToStringState(string);
    }

    @Override
    public ToStringState onIdentifier(Expr expr, String string, long l) {
        String string2 = ToStringVisitor.escapeName(string);
        return new ToStringState(l == 0L ? string2 : string2 + "@" + Long.toString(l));
    }

    @Override
    public ToStringState onRecord(List<Map.Entry<String, ToStringState>> list) {
        if (list.isEmpty()) {
            return new ToStringState("{=}");
        }
        StringBuilder stringBuilder = new StringBuilder("{");
        Iterator<Map.Entry<String, ToStringState>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ToStringState> entry = iterator.next();
            stringBuilder.append(ToStringVisitor.escapeName(entry.getKey()));
            stringBuilder.append(" = ");
            stringBuilder.append(entry.getValue().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onRecordType(List<Map.Entry<String, ToStringState>> list) {
        StringBuilder stringBuilder = new StringBuilder("{");
        Iterator<Map.Entry<String, ToStringState>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ToStringState> entry = iterator.next();
            stringBuilder.append(ToStringVisitor.escapeName(entry.getKey()));
            stringBuilder.append(" : ");
            stringBuilder.append(entry.getValue().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onUnionType(List<Map.Entry<String, ToStringState>> list) {
        StringBuilder stringBuilder = new StringBuilder("<");
        Iterator<Map.Entry<String, ToStringState>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ToStringState> entry = iterator.next();
            stringBuilder.append(ToStringVisitor.escapeName(entry.getKey()));
            ToStringState toStringState = entry.getValue();
            if (toStringState != null) {
                stringBuilder.append(" : ");
                stringBuilder.append(toStringState.toString());
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" | ");
        }
        stringBuilder.append(">");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onNonEmptyList(List<ToStringState> list) {
        StringBuilder stringBuilder = new StringBuilder("[");
        Iterator<ToStringState> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onFieldAccess(ToStringState toStringState, String string) {
        return new ToStringState(toStringState.toString(ToStringState.PRIMITIVE) + "." + string, ToStringState.SELECTOR);
    }

    @Override
    public ToStringState onProjection(ToStringState toStringState, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(toStringState.toString(ToStringState.PRIMITIVE));
        stringBuilder.append(".{");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return new ToStringState(stringBuilder.toString(), ToStringState.SELECTOR);
    }

    @Override
    public ToStringState onProjectionByType(ToStringState toStringState, ToStringState toStringState2) {
        return new ToStringState(toStringState.toString(ToStringState.PRIMITIVE) + ".(" + toStringState2.toString() + ")", ToStringState.SELECTOR);
    }

    @Override
    public ToStringState onOperatorApplication(Operator operator, ToStringState toStringState, ToStringState toStringState2) {
        int n = ToStringState.getOperatorLevel(operator);
        if (n == ToStringState.COMPLETE) {
            return new ToStringState(toStringState.toString(ToStringState.SELECTOR) + " " + operator.toString() + " " + toStringState2.toString(ToStringState.SELECTOR), n);
        }
        return new ToStringState(toStringState.toString(n) + " " + operator.toString() + " " + toStringState2.toString(n + 1), n);
    }

    @Override
    public ToStringState onMissingImport(Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("missing");
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), ToStringState.IMPORT);
    }

    @Override
    public ToStringState onEnvImport(String string, Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("env:");
        stringBuilder.append(string);
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), ToStringState.IMPORT);
    }

    @Override
    public ToStringState onLocalImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(path.toString());
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), ToStringState.IMPORT);
    }

    @Override
    public ToStringState onClasspathImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("classpath:");
        stringBuilder.append(path.toString());
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), ToStringState.IMPORT);
    }

    @Override
    public ToStringState onRemoteImport(URI uRI, ToStringState toStringState, Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(uRI.toString());
        if (toStringState != null) {
            stringBuilder.append(" using ");
            stringBuilder.append(toStringState.toString(ToStringState.IMPORT));
        }
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), ToStringState.IMPORT);
    }

    @Override
    public ToStringState onMerge(ToStringState toStringState, ToStringState toStringState2, ToStringState toStringState3) {
        StringBuilder stringBuilder = new StringBuilder("merge ");
        stringBuilder.append(toStringState.toString(ToStringState.IMPORT));
        stringBuilder.append(" ");
        stringBuilder.append(toStringState2.toString(ToStringState.IMPORT));
        if (toStringState3 != null) {
            stringBuilder.append(" : ");
            stringBuilder.append(toStringState3.toString(ToStringState.APPLICATION));
            return new ToStringState(stringBuilder.toString(), 0);
        }
        return new ToStringState(stringBuilder.toString(), ToStringState.APPLICATION);
    }

    @Override
    public ToStringState onLambda(String string, ToStringState toStringState, ToStringState toStringState2) {
        return new ToStringState("\u03bb(" + ToStringVisitor.escapeName(string) + " : " + toStringState.toString() + ") \u2192 " + toStringState2.toString(), 0);
    }

    @Override
    public ToStringState onPi(String string, ToStringState toStringState, ToStringState toStringState2) {
        String string2 = toStringState2.toString();
        return new ToStringState(string.equals("_") ? toStringState.toString(1) + " \u2192 " + string2 : "\u2200(" + ToStringVisitor.escapeName(string) + " : " + toStringState.toString() + ") \u2192 " + string2, 0);
    }

    @Override
    public ToStringState onLet(List<Expr.LetBinding<ToStringState>> list, ToStringState toStringState) {
        String string = toStringState.toString();
        for (int i = list.size() - 1; i >= 0; --i) {
            Expr.LetBinding<ToStringState> letBinding = list.get(i);
            String string2 = letBinding.hasType() ? " : " + letBinding.getType().toString() : "";
            string = "let " + ToStringVisitor.escapeName(letBinding.getName()) + string2 + " = " + letBinding.getValue().toString() + " in " + string;
        }
        return new ToStringState(string, 0);
    }

    @Override
    public ToStringState onText(String[] stringArray, List<ToStringState> list) {
        StringBuilder stringBuilder = new StringBuilder("\"");
        stringBuilder.append(Expr.Util.escapeText(stringArray[0], false));
        int n = 1;
        Iterator<ToStringState> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("${");
            stringBuilder.append(iterator.next().toString());
            stringBuilder.append("}");
            stringBuilder.append(Expr.Util.escapeText(stringArray[n++], false));
        }
        if (n < stringArray.length) {
            stringBuilder.append(Expr.Util.escapeText(stringArray[n], false));
        }
        stringBuilder.append("\"");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onEmptyList(ToStringState toStringState) {
        return new ToStringState("[] : " + toStringState.toString(ToStringState.APPLICATION), 0);
    }

    @Override
    public ToStringState onApplication(ToStringState toStringState, List<ToStringState> list) {
        StringBuilder stringBuilder = new StringBuilder(toStringState.toString(ToStringState.IMPORT));
        stringBuilder.append(" ");
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i).toString(ToStringState.IMPORT));
            if (i >= list.size() - 1) continue;
            stringBuilder.append(" ");
        }
        return new ToStringState(stringBuilder.toString(), ToStringState.APPLICATION);
    }

    @Override
    public ToStringState onIf(ToStringState toStringState, ToStringState toStringState2, ToStringState toStringState3) {
        return new ToStringState("if " + toStringState.toString() + " then " + toStringState2.toString() + " else " + toStringState3.toString(), 0);
    }

    @Override
    public ToStringState onAnnotated(ToStringState toStringState, ToStringState toStringState2) {
        return new ToStringState(toStringState.toString(1) + " : " + toStringState2.toString(), 0);
    }

    @Override
    public ToStringState onAssert(ToStringState toStringState) {
        return new ToStringState("assert : " + toStringState.toString(), 0);
    }

    @Override
    public ToStringState onToMap(ToStringState toStringState, ToStringState toStringState2) {
        StringBuilder stringBuilder = new StringBuilder("toMap ");
        stringBuilder.append(toStringState.toString(ToStringState.IMPORT));
        if (toStringState2 != null) {
            stringBuilder.append(" : ");
            stringBuilder.append(toStringState2.toString(ToStringState.APPLICATION));
            return new ToStringState(stringBuilder.toString(), 0);
        }
        return new ToStringState(stringBuilder.toString(), ToStringState.APPLICATION);
    }

    @Override
    public ToStringState onWith(ToStringState toStringState, String[] stringArray, ToStringState toStringState2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(toStringState.toString(ToStringState.IMPORT));
        stringBuilder.append(" with ");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(".");
        }
        stringBuilder.append(stringArray[stringArray.length - 1]);
        stringBuilder.append(" = ");
        stringBuilder.append(toStringState2.toString(1));
        return new ToStringState(stringBuilder.toString(), 0);
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isSimpleLabel(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!ToStringVisitor.isAlpha(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (ToStringVisitor.isAlpha(c) || ToStringVisitor.isDigit(c) || c == '-' || c == '/' || c == '_') continue;
            return false;
        }
        return true;
    }

    private static String escapeName(String string) {
        if (!ToStringVisitor.isSimpleLabel(string) || Expr.Constants.isBuiltIn(string) || Expr.Constants.isKeyword(string)) {
            return "`" + string + "`";
        }
        return string;
    }
}

