/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.Source;

public interface Visitor<A> {
    public void bind(String var1, Expr var2);

    public A onNote(A var1, Source var2);

    public A onNatural(Expr var1, BigInteger var2);

    public A onInteger(Expr var1, BigInteger var2);

    public A onDouble(Expr var1, double var2);

    public A onDate(Expr var1, int var2, int var3, int var4);

    public A onTime(Expr var1, int var2, int var3, int var4, BigDecimal var5);

    public A onTimeZone(Expr var1, int var2);

    public A onBuiltIn(Expr var1, String var2);

    public A onIdentifier(Expr var1, String var2, long var3);

    public A onLambda(String var1, A var2, A var3);

    public A onPi(String var1, A var2, A var3);

    public A onLet(List<Expr.LetBinding<A>> var1, A var2);

    public A onText(String[] var1, List<A> var2);

    public A onNonEmptyList(List<A> var1);

    public A onEmptyList(A var1);

    public A onRecord(List<Map.Entry<String, A>> var1);

    public A onRecordType(List<Map.Entry<String, A>> var1);

    public A onUnionType(List<Map.Entry<String, A>> var1);

    public A onFieldAccess(A var1, String var2);

    public A onProjection(A var1, String[] var2);

    public A onProjectionByType(A var1, A var2);

    public A onApplication(A var1, List<A> var2);

    public A onOperatorApplication(Operator var1, A var2, A var3);

    public A onIf(A var1, A var2, A var3);

    public A onAnnotated(A var1, A var2);

    public A onAssert(A var1);

    public A onMerge(A var1, A var2, A var3);

    public A onToMap(A var1, A var2);

    public A onWith(A var1, String[] var2, A var3);

    public A onMissingImport(Expr.ImportMode var1, byte[] var2);

    public A onEnvImport(String var1, Expr.ImportMode var2, byte[] var3);

    public A onLocalImport(Path var1, Expr.ImportMode var2, byte[] var3);

    public A onClasspathImport(Path var1, Expr.ImportMode var2, byte[] var3);

    public A onRemoteImport(URI var1, A var2, Expr.ImportMode var3, byte[] var4);

    public boolean sortFields();

    public boolean flattenToMapLists();

    public boolean prepareLambda(String var1, Expr var2);

    public boolean preparePi(String var1, Expr var2);

    public boolean prepareLet(int var1);

    public boolean prepareLetBinding(String var1, Expr var2);

    public boolean prepareText(int var1);

    public boolean prepareTextPart(String var1);

    public boolean prepareNonEmptyList(int var1);

    public boolean prepareNonEmptyListElement(int var1);

    public boolean prepareEmptyList(Expr var1);

    public boolean prepareRecord(int var1);

    public boolean prepareRecordField(String var1, Expr var2, int var3);

    public boolean prepareRecordType(int var1);

    public boolean prepareRecordTypeField(String var1, Expr var2, int var3);

    public boolean prepareUnionType(int var1);

    public boolean prepareUnionTypeField(String var1, Expr var2, int var3);

    public boolean prepareFieldAccess(Expr var1, String var2);

    public boolean prepareProjection(int var1);

    public boolean prepareProjectionByType();

    public boolean prepareProjectionByType(Expr var1);

    public boolean prepareApplication(Expr var1, int var2);

    public boolean prepareOperatorApplication(Operator var1);

    public boolean prepareIf();

    public boolean prepareAnnotated(Expr var1);

    public boolean prepareAssert();

    public boolean prepareMerge(Expr var1);

    public boolean prepareToMap(Expr var1);

    public boolean prepareWith(String[] var1);

    public boolean prepareWithValue(String[] var1);

    public boolean prepareRemoteImport(URI var1, Expr var2, Expr.ImportMode var3, byte[] var4);

    public static abstract class Identity
    extends NoPrepareEvents<Expr> {
        @Override
        public Expr onNote(Expr expr, Source source) {
            return Expr.makeNote(expr, source);
        }

        @Override
        public Expr onNatural(Expr expr, BigInteger bigInteger) {
            return expr;
        }

        @Override
        public Expr onInteger(Expr expr, BigInteger bigInteger) {
            return expr;
        }

        @Override
        public Expr onDouble(Expr expr, double d) {
            return expr;
        }

        @Override
        public Expr onDate(Expr expr, int n, int n2, int n3) {
            return expr;
        }

        @Override
        public Expr onTime(Expr expr, int n, int n2, int n3, BigDecimal bigDecimal) {
            return expr;
        }

        @Override
        public Expr onTimeZone(Expr expr, int n) {
            return expr;
        }

        @Override
        public Expr onBuiltIn(Expr expr, String string) {
            return expr;
        }

        @Override
        public Expr onIdentifier(Expr expr, String string, long l) {
            return expr;
        }

        @Override
        public Expr onLambda(String string, Expr expr, Expr expr2) {
            return Expr.makeLambda(string, expr, expr2);
        }

        @Override
        public Expr onPi(String string, Expr expr, Expr expr2) {
            return Expr.makePi(string, expr, expr2);
        }

        @Override
        public Expr onLet(List<Expr.LetBinding<Expr>> list, Expr expr) {
            return Expr.makeLet(list, expr);
        }

        @Override
        public Expr onText(String[] stringArray, List<Expr> list) {
            return Expr.makeTextLiteral(stringArray, list);
        }

        @Override
        public Expr onNonEmptyList(List<Expr> list) {
            return Expr.makeNonEmptyListLiteral(list);
        }

        @Override
        public Expr onEmptyList(Expr expr) {
            return Expr.makeEmptyListLiteral(expr);
        }

        @Override
        public Expr onRecord(List<Map.Entry<String, Expr>> list) {
            return Expr.makeRecordLiteral(list);
        }

        @Override
        public Expr onRecordType(List<Map.Entry<String, Expr>> list) {
            return Expr.makeRecordType(list);
        }

        @Override
        public Expr onUnionType(List<Map.Entry<String, Expr>> list) {
            return Expr.makeUnionType(list);
        }

        @Override
        public Expr onFieldAccess(Expr expr, String string) {
            return Expr.makeFieldAccess(expr, string);
        }

        @Override
        public Expr onProjection(Expr expr, String[] stringArray) {
            return Expr.makeProjection(expr, stringArray);
        }

        @Override
        public Expr onProjectionByType(Expr expr, Expr expr2) {
            return Expr.makeProjectionByType(expr, expr2);
        }

        @Override
        public Expr onApplication(Expr expr, List<Expr> list) {
            return Expr.makeApplication(expr, list);
        }

        @Override
        public Expr onOperatorApplication(Operator operator, Expr expr, Expr expr2) {
            return Expr.makeOperatorApplication(operator, expr, expr2);
        }

        @Override
        public Expr onIf(Expr expr, Expr expr2, Expr expr3) {
            return Expr.makeIf(expr, expr2, expr3);
        }

        @Override
        public Expr onAnnotated(Expr expr, Expr expr2) {
            return Expr.makeAnnotated(expr, expr2);
        }

        @Override
        public Expr onAssert(Expr expr) {
            return Expr.makeAssert(expr);
        }

        @Override
        public Expr onMerge(Expr expr, Expr expr2, Expr expr3) {
            return Expr.makeMerge(expr, expr2, expr3);
        }

        @Override
        public Expr onToMap(Expr expr, Expr expr2) {
            return Expr.makeToMap(expr, expr2);
        }

        @Override
        public Expr onWith(Expr expr, String[] stringArray, Expr expr2) {
            return Expr.makeWith(expr, stringArray, expr2);
        }

        @Override
        public Expr onMissingImport(Expr.ImportMode importMode, byte[] byArray) {
            return Expr.makeMissingImport(importMode, byArray);
        }

        @Override
        public Expr onEnvImport(String string, Expr.ImportMode importMode, byte[] byArray) {
            return Expr.makeEnvImport(string, importMode, byArray);
        }

        @Override
        public Expr onLocalImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
            return Expr.makeLocalImport(path, importMode, byArray);
        }

        @Override
        public Expr onClasspathImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
            return Expr.makeClasspathImport(path, importMode, byArray);
        }

        @Override
        public Expr onRemoteImport(URI uRI, Expr expr, Expr.ImportMode importMode, byte[] byArray) {
            return Expr.makeRemoteImport(uRI, expr, importMode, byArray);
        }
    }

    public static class Property
    extends Constant<Boolean> {
        public Property() {
            super(true);
        }

        @Override
        public Boolean onLambda(String string, Boolean bl, Boolean bl2) {
            return bl != false && bl2 != false;
        }

        @Override
        public Boolean onPi(String string, Boolean bl, Boolean bl2) {
            return bl != false && bl2 != false;
        }

        @Override
        public Boolean onLet(List<Expr.LetBinding<Boolean>> list, Boolean bl) {
            if (!bl.booleanValue()) {
                return false;
            }
            for (Expr.LetBinding<Boolean> letBinding : list) {
                if (letBinding.getValue().booleanValue() && (!letBinding.hasType() || letBinding.getType().booleanValue())) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean onText(String[] stringArray, List<Boolean> list) {
            for (Boolean bl : list) {
                if (bl.booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean onNonEmptyList(List<Boolean> list) {
            for (Boolean bl : list) {
                if (bl.booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean onEmptyList(Boolean bl) {
            return bl;
        }

        @Override
        public Boolean onRecord(List<Map.Entry<String, Boolean>> list) {
            for (Map.Entry<String, Boolean> entry : list) {
                if (entry.getValue().booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean onRecordType(List<Map.Entry<String, Boolean>> list) {
            for (Map.Entry<String, Boolean> entry : list) {
                if (entry.getValue().booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean onUnionType(List<Map.Entry<String, Boolean>> list) {
            for (Map.Entry<String, Boolean> entry : list) {
                if (entry.getValue() == null || entry.getValue().booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean onFieldAccess(Boolean bl, String string) {
            return bl;
        }

        @Override
        public Boolean onProjection(Boolean bl, String[] stringArray) {
            return bl;
        }

        @Override
        public Boolean onProjectionByType(Boolean bl, Boolean bl2) {
            return bl != false && bl2 != false;
        }

        @Override
        public Boolean onApplication(Boolean bl, List<Boolean> list) {
            if (!bl.booleanValue()) {
                return false;
            }
            for (Boolean bl2 : list) {
                if (bl2.booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean onOperatorApplication(Operator operator, Boolean bl, Boolean bl2) {
            return bl != false && bl2 != false;
        }

        @Override
        public Boolean onIf(Boolean bl, Boolean bl2, Boolean bl3) {
            return bl != false && bl2 != false && bl3 != false;
        }

        @Override
        public Boolean onAnnotated(Boolean bl, Boolean bl2) {
            return bl != false && bl2 != false;
        }

        @Override
        public Boolean onAssert(Boolean bl) {
            return bl;
        }

        @Override
        public Boolean onMerge(Boolean bl, Boolean bl2, Boolean bl3) {
            return bl != false && bl2 != false && (bl3 == null || bl3 != false);
        }

        @Override
        public Boolean onToMap(Boolean bl, Boolean bl2) {
            return bl != false && (bl2 == null || bl2 != false);
        }

        public Boolean onToMap(Boolean bl, String[] stringArray, Boolean bl2) {
            return bl != false && bl2 != false;
        }

        @Override
        public Boolean onLocalImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
            return true;
        }

        @Override
        public Boolean onRemoteImport(URI uRI, Boolean bl, Expr.ImportMode importMode, byte[] byArray) {
            return true;
        }

        @Override
        public Boolean onEnvImport(String string, Expr.ImportMode importMode, byte[] byArray) {
            return true;
        }

        @Override
        public Boolean onMissingImport(Expr.ImportMode importMode, byte[] byArray) {
            return true;
        }
    }

    public static class Constant<A>
    extends NoPrepareEvents<A> {
        private final A returnValue;

        protected A getReturnValue() {
            return this.returnValue;
        }

        public Constant(A a) {
            this.returnValue = a;
        }

        @Override
        public void bind(String string, Expr expr) {
        }

        @Override
        public A onNote(A a, Source source) {
            return a;
        }

        @Override
        public A onNatural(Expr expr, BigInteger bigInteger) {
            return this.getReturnValue();
        }

        @Override
        public A onInteger(Expr expr, BigInteger bigInteger) {
            return this.getReturnValue();
        }

        @Override
        public A onDouble(Expr expr, double d) {
            return this.getReturnValue();
        }

        @Override
        public A onDate(Expr expr, int n, int n2, int n3) {
            return this.getReturnValue();
        }

        @Override
        public A onTime(Expr expr, int n, int n2, int n3, BigDecimal bigDecimal) {
            return this.getReturnValue();
        }

        @Override
        public A onTimeZone(Expr expr, int n) {
            return this.getReturnValue();
        }

        @Override
        public A onBuiltIn(Expr expr, String string) {
            return this.getReturnValue();
        }

        @Override
        public A onIdentifier(Expr expr, String string, long l) {
            return this.getReturnValue();
        }

        @Override
        public A onLambda(String string, A a, A a2) {
            return this.getReturnValue();
        }

        @Override
        public A onPi(String string, A a, A a2) {
            return this.getReturnValue();
        }

        @Override
        public A onLet(List<Expr.LetBinding<A>> list, A a) {
            return this.getReturnValue();
        }

        @Override
        public A onText(String[] stringArray, List<A> list) {
            return this.getReturnValue();
        }

        @Override
        public A onNonEmptyList(List<A> list) {
            return this.getReturnValue();
        }

        @Override
        public A onEmptyList(A a) {
            return this.getReturnValue();
        }

        @Override
        public A onRecord(List<Map.Entry<String, A>> list) {
            return this.getReturnValue();
        }

        @Override
        public A onRecordType(List<Map.Entry<String, A>> list) {
            return this.getReturnValue();
        }

        @Override
        public A onUnionType(List<Map.Entry<String, A>> list) {
            return this.getReturnValue();
        }

        @Override
        public A onFieldAccess(A a, String string) {
            return this.getReturnValue();
        }

        @Override
        public A onProjection(A a, String[] stringArray) {
            return this.getReturnValue();
        }

        @Override
        public A onProjectionByType(A a, A a2) {
            return this.getReturnValue();
        }

        @Override
        public A onApplication(A a, List<A> list) {
            return this.getReturnValue();
        }

        @Override
        public A onOperatorApplication(Operator operator, A a, A a2) {
            return this.getReturnValue();
        }

        @Override
        public A onIf(A a, A a2, A a3) {
            return this.getReturnValue();
        }

        @Override
        public A onAnnotated(A a, A a2) {
            return this.getReturnValue();
        }

        @Override
        public A onAssert(A a) {
            return this.getReturnValue();
        }

        @Override
        public A onMerge(A a, A a2, A a3) {
            return this.getReturnValue();
        }

        @Override
        public A onToMap(A a, A a2) {
            return this.getReturnValue();
        }

        @Override
        public A onWith(A a, String[] stringArray, A a2) {
            return this.getReturnValue();
        }

        @Override
        public A onMissingImport(Expr.ImportMode importMode, byte[] byArray) {
            return this.getReturnValue();
        }

        @Override
        public A onEnvImport(String string, Expr.ImportMode importMode, byte[] byArray) {
            return this.getReturnValue();
        }

        @Override
        public A onLocalImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
            return this.getReturnValue();
        }

        @Override
        public A onClasspathImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
            return this.getReturnValue();
        }

        @Override
        public A onRemoteImport(URI uRI, A a, Expr.ImportMode importMode, byte[] byArray) {
            return this.getReturnValue();
        }
    }

    public static abstract class NoPrepareEvents<A>
    implements Visitor<A> {
        @Override
        public void bind(String string, Expr expr) {
        }

        @Override
        public boolean sortFields() {
            return false;
        }

        @Override
        public boolean flattenToMapLists() {
            return false;
        }

        @Override
        public boolean prepareLambda(String string, Expr expr) {
            return true;
        }

        @Override
        public boolean preparePi(String string, Expr expr) {
            return true;
        }

        @Override
        public boolean prepareLet(int n) {
            return true;
        }

        @Override
        public boolean prepareLetBinding(String string, Expr expr) {
            return true;
        }

        @Override
        public boolean prepareText(int n) {
            return true;
        }

        @Override
        public boolean prepareTextPart(String string) {
            return true;
        }

        @Override
        public boolean prepareNonEmptyList(int n) {
            return true;
        }

        @Override
        public boolean prepareNonEmptyListElement(int n) {
            return true;
        }

        @Override
        public boolean prepareEmptyList(Expr expr) {
            return true;
        }

        @Override
        public boolean prepareRecord(int n) {
            return true;
        }

        @Override
        public boolean prepareRecordField(String string, Expr expr, int n) {
            return true;
        }

        @Override
        public boolean prepareRecordType(int n) {
            return true;
        }

        @Override
        public boolean prepareRecordTypeField(String string, Expr expr, int n) {
            return true;
        }

        @Override
        public boolean prepareUnionType(int n) {
            return true;
        }

        @Override
        public boolean prepareUnionTypeField(String string, Expr expr, int n) {
            return true;
        }

        @Override
        public boolean prepareFieldAccess(Expr expr, String string) {
            return true;
        }

        @Override
        public boolean prepareProjection(int n) {
            return true;
        }

        @Override
        public boolean prepareProjectionByType() {
            return true;
        }

        @Override
        public boolean prepareProjectionByType(Expr expr) {
            return true;
        }

        @Override
        public boolean prepareApplication(Expr expr, int n) {
            return true;
        }

        @Override
        public boolean prepareOperatorApplication(Operator operator) {
            return true;
        }

        @Override
        public boolean prepareIf() {
            return true;
        }

        @Override
        public boolean prepareAnnotated(Expr expr) {
            return true;
        }

        @Override
        public boolean prepareAssert() {
            return true;
        }

        @Override
        public boolean prepareMerge(Expr expr) {
            return true;
        }

        @Override
        public boolean prepareToMap(Expr expr) {
            return true;
        }

        @Override
        public boolean prepareWith(String[] stringArray) {
            return true;
        }

        @Override
        public boolean prepareWithValue(String[] stringArray) {
            return true;
        }

        @Override
        public boolean prepareRemoteImport(URI uRI, Expr expr, Expr.ImportMode importMode, byte[] byArray) {
            return true;
        }
    }
}

