/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.typechecking;

import org.dhallj.core.Expr;

public enum Universe {
    TYPE,
    KIND,
    SORT;


    public final Universe max(Universe universe) {
        if (this == SORT || universe == SORT) {
            return SORT;
        }
        if (this == KIND || universe == KIND) {
            return KIND;
        }
        return TYPE;
    }

    public final Expr toExpr() {
        if (this == TYPE) {
            return Expr.Constants.TYPE;
        }
        if (this == KIND) {
            return Expr.Constants.KIND;
        }
        return Expr.Constants.SORT;
    }

    public static final boolean isUniverse(Expr expr) {
        return Universe.fromExpr(expr) != null;
    }

    public static final Universe fromExpr(Expr expr) {
        String string = Expr.Util.asBuiltIn(expr);
        if (string != null) {
            if (string.equals("Type")) {
                return TYPE;
            }
            if (string.equals("Kind")) {
                return KIND;
            }
            if (string.equals("Sort")) {
                return SORT;
            }
        }
        return null;
    }

    public static Universe functionCheck(Universe universe, Universe universe2) {
        if (universe == null || universe2 == null) {
            return null;
        }
        if (universe2 == TYPE) {
            return TYPE;
        }
        return universe.max(universe2);
    }
}

